/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import mobi.f2time.dorado.exception.DoradoException;
import mobi.f2time.dorado.rest.util.FileUtils;
import mobi.f2time.dorado.rest.util.LogUtils;

public class PackageScanner {
    public static List<Class<?>> scan(String packageName) throws ClassNotFoundException {
        LinkedList classes = new LinkedList();
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> urls = loader.getResources(packageName.replace('.', '/'));
            block10: while (urls.hasMoreElements()) {
                URI uri = urls.nextElement().toURI();
                switch (uri.getScheme().toLowerCase()) {
                    case "jar": {
                        PackageScanner.scanFromJarProtocol(loader, classes, uri.getRawSchemeSpecificPart());
                        continue block10;
                    }
                    case "file": {
                        PackageScanner.scanFromFileProtocol(loader, classes, uri.getPath(), packageName);
                        continue block10;
                    }
                }
                throw new URISyntaxException(uri.getScheme(), "unknown schema " + uri.getScheme());
            }
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
        return classes;
    }

    private static Class<?> loadClass(ClassLoader loader, String classPath) throws ClassNotFoundException {
        try {
            classPath = classPath.substring(0, classPath.length() - 6);
            return loader.loadClass(classPath);
        }
        catch (Throwable cause) {
            LogUtils.error("", cause);
            return null;
        }
    }

    private static void scanFromFileProtocol(ClassLoader loader, List<Class<?>> classes, String dir, String packageName) throws ClassNotFoundException {
        try {
            List<String> classNames = PackageScanner.listAllClassNames(dir);
            classNames.forEach(className -> {
                try {
                    classes.add(PackageScanner.loadClass(loader, String.format("%s.%s", packageName, className)));
                }
                catch (Throwable e) {
                    LogUtils.error(e.getMessage(), new Object[0]);
                }
            });
        }
        catch (Exception ex) {
            throw new DoradoException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scanFromJarProtocol(ClassLoader loader, List<Class<?>> classes, String fullPath) throws ClassNotFoundException {
        String jar = fullPath.substring(0, fullPath.lastIndexOf(33));
        String parent = fullPath.substring(fullPath.lastIndexOf(33) + 2);
        JarEntry e = null;
        ZipInputStream jarReader = null;
        try {
            jarReader = new JarInputStream(new URL(jar).openStream());
            while ((e = ((JarInputStream)jarReader).getNextJarEntry()) != null) {
                String className = e.getName();
                if (!e.isDirectory() && className.startsWith(parent) && className.endsWith(".class") && !className.contains("$")) {
                    className = className.replace('/', '.');
                    classes.add(PackageScanner.loadClass(loader, className));
                }
                jarReader.closeEntry();
            }
        }
        catch (IOException error) {
            error.printStackTrace();
        }
        finally {
            try {
                if (jarReader != null) {
                    jarReader.close();
                }
            }
            catch (IOException exp) {
                exp.printStackTrace();
            }
        }
    }

    public static List<String> listAllClassNames(String classpath) {
        ArrayList<String> classNames = new ArrayList<String>();
        List<File> allClassFiles = FileUtils.listFiles(new File(classpath), ".class", true);
        int index = classpath.endsWith(File.separator) ? classpath.length() : classpath.length() + 1;
        for (File classFile : allClassFiles) {
            String className = classFile.getAbsolutePath().substring(index).replace(File.separatorChar, '.');
            classNames.add(className);
        }
        return classNames;
    }

    public static void main(String[] args) throws Exception {
        String packageName = "mobi.f2time";
        List<Class<?>> classes = PackageScanner.scan(packageName);
        classes.forEach(type -> System.out.println(type.getName()));
    }
}

