/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.spring;

import mobi.f2time.dorado.BeanContainer;
import mobi.f2time.dorado.Dorado;
import mobi.f2time.dorado.rest.annotation.Controller;
import mobi.f2time.dorado.rest.controller.RootController;
import mobi.f2time.dorado.rest.server.DoradoServerBuilder;
import mobi.f2time.dorado.spring.DoradoApplicationContext;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public final class SpringContainer
implements BeanContainer {
    private static SpringContainer instance;
    private final ApplicationContext applicationContext;

    private SpringContainer(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        Dorado.beanContainer = this;
    }

    public static synchronized void create(ApplicationContext applicationContext) {
        DoradoServerBuilder builder = Dorado.serverConfig;
        if (builder == null) {
            throw new IllegalStateException("Please init DoradoServer first!");
        }
        if (!(applicationContext instanceof DoradoApplicationContext) && applicationContext instanceof BeanDefinitionRegistry) {
            ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner((BeanDefinitionRegistry)applicationContext);
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Controller.class));
            scanner.scan(builder.scanPackages());
        }
        instance = new SpringContainer(applicationContext);
        Dorado.springInitialized = true;
    }

    public static SpringContainer get() {
        return instance;
    }

    @Override
    public <T> T getBean(Class<T> type) {
        if (type == RootController.class) {
            return BeanContainer.DEFAULT.getBean(type);
        }
        return (T)this.applicationContext.getBean(type);
    }

    public static void create(String[] scanPackages) {
        if (instance != null) {
            throw new IllegalStateException("SpringContainer has been initialized");
        }
        DoradoApplicationContext applicationContext = new DoradoApplicationContext(scanPackages);
        SpringContainer.create((ApplicationContext)applicationContext);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> applicationContext.close()));
    }
}

