/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mobi.f2time.dorado.rest.ParameterValueResolver;
import mobi.f2time.dorado.rest.annotation.HeaderParam;
import mobi.f2time.dorado.rest.annotation.PathVariable;
import mobi.f2time.dorado.rest.annotation.RequestBody;
import mobi.f2time.dorado.rest.annotation.RequestParam;
import mobi.f2time.dorado.rest.http.HttpRequest;
import mobi.f2time.dorado.rest.http.HttpResponse;

public class ParameterValueResolvers {
    private static Map<Class<?>, ParameterValueResolver> parameterValueResolverHolder = new ConcurrentHashMap();

    public static ParameterValueResolver getParameterValueResolver(Class<?> parameterAnnotationType) {
        if (parameterAnnotationType == null) {
            return ParameterValueResolver.ALL;
        }
        ParameterValueResolver parameterValueResolver = parameterValueResolverHolder.get(parameterAnnotationType);
        if (parameterValueResolver == null) {
            return ParameterValueResolver.ALL;
        }
        return parameterValueResolverHolder.get(parameterAnnotationType);
    }

    static {
        parameterValueResolverHolder.put(RequestParam.class, ParameterValueResolver.REQUEST_PARAM);
        parameterValueResolverHolder.put(HeaderParam.class, ParameterValueResolver.HEADER_PARAM);
        parameterValueResolverHolder.put(PathVariable.class, ParameterValueResolver.PATH_PARAM);
        parameterValueResolverHolder.put(HttpRequest.class, ParameterValueResolver.HTTP_REQUEST);
        parameterValueResolverHolder.put(HttpResponse.class, ParameterValueResolver.HTTP_RESPONSE);
        parameterValueResolverHolder.put(RequestBody.class, ParameterValueResolver.REQUEST_BODY);
    }
}

