/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest.router;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import mobi.f2time.dorado.rest.http.HttpRequest;
import mobi.f2time.dorado.rest.router.UriRoutingController;
import mobi.f2time.dorado.rest.router.UriRoutingMatchResult;
import mobi.f2time.dorado.rest.router.UriRoutingPath;

public class UriRoutingRegistry {
    private static final UriRoutingRegistry _instance = new UriRoutingRegistry();
    private List<UriRouting> uriRoutingRegistry = new ArrayList<UriRouting>();

    private UriRoutingRegistry() {
    }

    public static UriRoutingRegistry getInstance() {
        return _instance;
    }

    public void register(UriRoutingPath routeMapping, UriRoutingController controller) {
        this.uriRoutingRegistry.add(UriRouting.create(routeMapping, controller));
        this.uriRoutingRegistry.sort((a, b) -> ((UriRouting)a).path.compareTo(((UriRouting)b).path));
    }

    public UriRoutingMatchResult findRouteController(HttpRequest request) {
        Matcher matchResult = null;
        String routingMethod = null;
        for (UriRouting uriRouting : this.uriRoutingRegistry) {
            routingMethod = uriRouting.path.httpMethod();
            matchResult = uriRouting.path.routingPathPattern().matcher(request.getRequestURI());
            if (!matchResult.matches() || routingMethod != null && !request.getMethod().equals(routingMethod)) continue;
            return UriRoutingMatchResult.create(uriRouting.controller, matchResult);
        }
        return null;
    }

    public List<UriRouting> uriRoutings() {
        return Collections.unmodifiableList(this.uriRoutingRegistry);
    }

    public String toString() {
        return "UriRoutingRegistry [uriRouteMappingRegistry=" + this.uriRoutingRegistry + "]";
    }

    public void clear() {
        this.uriRoutingRegistry.clear();
    }

    public static class UriRouting {
        private final UriRoutingPath path;
        private final UriRoutingController controller;

        private UriRouting(UriRoutingPath path, UriRoutingController controller) {
            this.path = path;
            this.controller = controller;
        }

        public static UriRouting create(UriRoutingPath path, UriRoutingController controller) {
            return new UriRouting(path, controller);
        }

        public UriRoutingPath uriRoutingPath() {
            return this.path;
        }

        public UriRoutingController controller() {
            return this.controller;
        }

        public String toString() {
            return "UriRouting [path=" + this.path + ", controller=" + this.controller + "]";
        }
    }
}

