/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.timeout.IdleStateHandler;
import mobi.f2time.dorado.Dorado;
import mobi.f2time.dorado.rest.http.impl.Webapp;
import mobi.f2time.dorado.rest.server.DoradoServerBuilder;
import mobi.f2time.dorado.rest.server.DoradoServerHandler;
import mobi.f2time.dorado.rest.util.ClassLoaderUtils;
import mobi.f2time.dorado.rest.util.LogUtils;
import mobi.f2time.dorado.spring.SpringContainer;

public class DoradoServer {
    private final DoradoServerBuilder builder;

    public DoradoServer(DoradoServerBuilder builder) {
        this.builder = builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        System.out.println(ClassLoaderUtils.getResoureAsString("dorado-ascii"));
        System.out.println();
        if (this.builder.isSpringOn() && !Dorado.springInitialized) {
            SpringContainer.create(this.builder.scanPackages());
        }
        Webapp.create(this.builder.scanPackages(), this.builder.isSpringOn());
        NioEventLoopGroup acceptor = new NioEventLoopGroup(this.builder.getAcceptors());
        NioEventLoopGroup worker = new NioEventLoopGroup(this.builder.getIoWorkers());
        ServerBootstrap bootstrap = null;
        try {
            bootstrap = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)acceptor, (EventLoopGroup)worker).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new DoradoChannelInitializer(this.builder));
            bootstrap.option(ChannelOption.SO_BACKLOG, (Object)this.builder.getBacklog());
            bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true);
            bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)this.builder.getSendBuffer());
            bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)this.builder.getRecvBuffer());
            ChannelFuture f = bootstrap.bind(this.builder.getPort()).sync();
            LogUtils.info(String.format("Dorado application initialized with port: %d (http)", this.builder.getPort()));
            f.channel().closeFuture().sync();
        }
        catch (Throwable ex) {
            LogUtils.error("Start dorado application failed, cause: " + ex.getMessage(), ex);
        }
        finally {
            worker.shutdownGracefully();
            acceptor.shutdownGracefully();
        }
    }

    static class DoradoChannelInitializer
    extends ChannelInitializer<Channel> {
        private final DoradoServerBuilder builder;

        public DoradoChannelInitializer(DoradoServerBuilder builder) {
            this.builder = builder;
        }

        protected void initChannel(Channel ch) throws Exception {
            ChannelPipeline pipeline = ch.pipeline();
            pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
            pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(this.builder.getMaxPacketLength())});
            pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(this.builder.getMaxIdleTime(), 0, 0)});
            pipeline.addLast(new ChannelHandler[]{DoradoServerHandler.create(this.builder)});
        }
    }
}

