/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest.util;

import java.util.HashMap;
import java.util.Map;
import mobi.f2time.dorado.rest.util.TypeConverter;

public class TypeConverters {
    private static Map<Class<?>, TypeConverter<?, ?>> converters = new HashMap();

    public static TypeConverter resolveConverter(Class<?> type) {
        TypeConverter<?, ?> converter = converters.get(type);
        return converter == null ? TypeConverter.DUMMY : converter;
    }

    static {
        converters.put(Integer.TYPE, TypeConverter.STRING_INT);
        converters.put(Long.TYPE, TypeConverter.STRING_LONG);
        converters.put(Double.TYPE, TypeConverter.STRING_DOUBLE);
        converters.put(Float.TYPE, TypeConverter.STRING_FLOAT);
        converters.put(Short.TYPE, TypeConverter.STRING_SHORT);
        converters.put(Boolean.TYPE, TypeConverter.STRING_BOOL);
        converters.put(Character.TYPE, TypeConverter.STRING_CHAR);
        converters.put(Byte.TYPE, TypeConverter.STRING_BYTE);
        converters.put(Float.class, TypeConverter.STRING_FLOAT_WRAPPER);
        converters.put(Integer.class, TypeConverter.STRING_INT_WRAPPER);
        converters.put(Long.class, TypeConverter.STRING_LONG_WRAPPER);
        converters.put(Double.class, TypeConverter.STRING_DOUBLE_WRAPPER);
        converters.put(Short.class, TypeConverter.STRING_SHORT_WRAPPER);
        converters.put(Boolean.class, TypeConverter.STRING_BOOL_WRAPPER);
        converters.put(Character.class, TypeConverter.STRING_CHAR_WRAPPER);
        converters.put(Byte.class, TypeConverter.STRING_BYTE_WRAPPER);
    }
}

