/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.springboot;

import javax.annotation.PostConstruct;
import mobi.f2time.dorado.rest.server.DoradoServer;
import mobi.f2time.dorado.rest.server.DoradoServerBuilder;
import mobi.f2time.dorado.spring.SpringContainer;
import mobi.f2time.dorado.springboot.DoradoConfig;
import mobi.f2time.dorado.springboot.EnableDorado;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@ConditionalOnClass(value={EnableDorado.class})
@EnableConfigurationProperties(value={DoradoConfig.class})
@Order(value=0x7FFFFFFF)
public class DoradoStarter {
    private static final Log LOG = LogFactory.getLog((String)"dorado-spring-boot-starter");
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private DoradoConfig config;

    @PostConstruct
    public void startDoradoServer() {
        if (!this.applicationContext.containsBean("springApplicationArguments")) {
            LOG.warn((Object)"Not SpringBootApplication, unstart dorado server");
            return;
        }
        int listenPort = this.config.getPort();
        if (listenPort == 0) {
            throw new IllegalArgumentException("Must be setting dorado.port property");
        }
        DoradoServerBuilder builder = DoradoServerBuilder.forPort(this.config.getPort());
        if (this.config.getAcceptors() > 0) {
            builder.acceptors(this.config.getAcceptors());
        }
        if (this.config.getIoWorkers() > 0) {
            builder.ioWorkers(this.config.getIoWorkers());
        }
        if (this.config.getMinWorkers() > 0 && this.config.getMaxWorkers() > 0) {
            builder.minWorkers(this.config.getMinWorkers()).maxWorkers(this.config.getMaxWorkers());
        }
        if (this.config.getBacklog() > 0) {
            builder.backlog(this.config.getBacklog());
        }
        if (this.config.getMaxConnections() > 0) {
            builder.maxConnection(this.config.getMaxConnections());
        }
        if (this.config.getMaxPendingRequest() > 0) {
            builder.maxPendingRequest(this.config.getMaxPendingRequest());
        }
        if (this.config.getMaxIdleTime() > 0) {
            builder.maxIdleTime(this.config.getMaxIdleTime());
        }
        if (this.config.getSendBuffer() > 0) {
            builder.sendBuffer(this.config.getSendBuffer());
        }
        if (this.config.getRecvBuffer() > 0) {
            builder.recvBuffer(this.config.getRecvBuffer());
        }
        if (this.config.getMaxPacketLength() > 0) {
            builder.maxPacketLength(this.config.getMaxPacketLength());
        }
        builder.scanPackages(this.config.getScanPackages());
        DoradoServer doradoServer = builder.build();
        SpringContainer.create(this.applicationContext);
        doradoServer.start();
    }
}

