/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest.controller;

import java.util.ArrayList;
import java.util.List;
import mobi.f2time.dorado.Dorado;
import mobi.f2time.dorado.rest.annotation.Controller;
import mobi.f2time.dorado.rest.annotation.Path;
import mobi.f2time.dorado.rest.controller.DoradoStatus;
import mobi.f2time.dorado.rest.controller.RestService;
import mobi.f2time.dorado.rest.router.UriRoutingPath;
import mobi.f2time.dorado.rest.router.UriRoutingRegistry;
import mobi.f2time.dorado.rest.server.DoradoServerBuilder;
import mobi.f2time.dorado.rest.util.StringUtils;

@Controller
@Path(value="/")
public class RootController {
    private static final String DORADO_WELCOME = "Welcome to dorado!";

    @Path
    public String index() {
        return DORADO_WELCOME;
    }

    @Path(value="status")
    public DoradoStatus status() {
        return DoradoStatus.get();
    }

    @Path(value="services")
    public List<RestService> services() {
        ArrayList<RestService> serviceList = new ArrayList<RestService>();
        List<UriRoutingRegistry.UriRouting> uriRoutings = UriRoutingRegistry.getInstance().uriRoutings();
        for (UriRoutingRegistry.UriRouting uriRouting : uriRoutings) {
            UriRoutingPath routingPath = uriRouting.uriRoutingPath();
            String path = routingPath.routingPath();
            String method = StringUtils.defaultString(routingPath.httpMethod(), "*");
            serviceList.add(RestService.builder().withPath(path).withMethod(method).build());
        }
        return serviceList;
    }

    @Path(value="config")
    public DoradoServerBuilder config() {
        return Dorado.serverConfig;
    }
}

