/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest.http.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import mobi.f2time.dorado.rest.http.FilterChain;
import mobi.f2time.dorado.rest.http.impl.FilterChainImpl;
import mobi.f2time.dorado.rest.http.impl.FilterConfiguration;

public class FilterManager {
    private static final String EXCLUDE_URL_PATTERN = "^//*$";
    private List<FilterConfiguration> doradoFilters = new ArrayList<FilterConfiguration>();
    private Pattern excludePattern = Pattern.compile("^//*$");
    private static final FilterManager INSTANCE = new FilterManager();

    private FilterManager() {
    }

    public static FilterManager getInstance() {
        return INSTANCE;
    }

    public void addFilter(FilterConfiguration filter) {
        this.doradoFilters.add(filter);
    }

    public FilterChain filter(String uri) {
        FilterChainImpl filterChain = new FilterChainImpl();
        if (this.excludePattern.matcher(uri).matches()) {
            return filterChain;
        }
        this.doradoFilters.stream().filter((? super T filter) -> filter.getUrlPattern().matcher(uri).matches()).forEachOrdered(filter -> filterChain.addFilter(filter.getFilter()));
        return filterChain;
    }
}

