/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest.http.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import mobi.f2time.dorado.exception.DoradoException;
import mobi.f2time.dorado.rest.annotation.Controller;
import mobi.f2time.dorado.rest.annotation.HttpMethod;
import mobi.f2time.dorado.rest.annotation.Path;
import mobi.f2time.dorado.rest.controller.RootController;
import mobi.f2time.dorado.rest.http.Filter;
import mobi.f2time.dorado.rest.http.impl.FilterConfiguration;
import mobi.f2time.dorado.rest.http.impl.FilterManager;
import mobi.f2time.dorado.rest.router.UriRoutingController;
import mobi.f2time.dorado.rest.router.UriRoutingPath;
import mobi.f2time.dorado.rest.router.UriRoutingRegistry;
import mobi.f2time.dorado.rest.util.ClassLoaderUtils;
import mobi.f2time.dorado.rest.util.LogUtils;
import mobi.f2time.dorado.rest.util.PackageScanner;
import mobi.f2time.dorado.rest.util.StringUtils;

public class Webapp {
    private static Webapp webapp;
    private static final String FILTER_URL_PATTERN_ALL = "^/.*";
    private final String[] packages;

    private Webapp(String[] packages, boolean springOn) {
        this.packages = packages;
    }

    public static synchronized void create(String[] packages) {
        Webapp.create(packages, false);
    }

    public static synchronized void create(String[] packages, boolean springOn) {
        webapp = new Webapp(packages, springOn);
        webapp.initialize();
    }

    public static Webapp get() {
        if (webapp == null) {
            throw new IllegalStateException("webapp not initialized, please create it first");
        }
        return webapp;
    }

    public void initialize() {
        ArrayList classes = new ArrayList();
        try {
            for (String scanPackage : this.packages) {
                classes.addAll(PackageScanner.scan(scanPackage));
            }
            this.initializeUriRouting(RootController.class);
            classes.forEach(clazz -> {
                this.initializeUriRouting((Class<?>)clazz);
                this.initializeWebFilters((Class<?>)clazz);
            });
            UriRoutingRegistry registry = this.getUriRoutingRegistry();
            if (registry.uriRoutings().isEmpty()) {
                LogUtils.warn("No Controller are registered, please check first");
            }
        }
        catch (Exception ex) {
            throw new DoradoException(ex);
        }
    }

    private void initializeWebFilters(Class<?> clazz) {
        if (!Filter.class.isAssignableFrom(clazz) || clazz.isInterface()) {
            return;
        }
        Path filterPath = clazz.getAnnotation(Path.class);
        String urlPattern = filterPath == null ? null : filterPath.value();
        urlPattern = StringUtils.defaultString(urlPattern, FILTER_URL_PATTERN_ALL);
        this.getFilterManager().addFilter(new FilterConfiguration(urlPattern, (Filter)ClassLoaderUtils.newInstance(clazz)));
    }

    private void initializeUriRouting(Class<?> c) {
        Method[] controllerMethods;
        Controller controller = c.getAnnotation(Controller.class);
        if (controller == null) {
            return;
        }
        Path classLevelPath = c.getAnnotation(Path.class);
        String controllerPath = classLevelPath == null ? "" : classLevelPath.value();
        for (Method method : controllerMethods = c.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || method.getAnnotations().length == 0 || !Modifier.isPublic(method.getModifiers())) continue;
            Path methodLevelPath = method.getAnnotation(Path.class);
            HttpMethod httpMethod = this.getHttpMethod(method.getAnnotations());
            String methodPath = methodLevelPath == null ? "" : methodLevelPath.value();
            UriRoutingPath uriRoutingPath = UriRoutingPath.create(String.format("%s%s", controllerPath, methodPath), httpMethod);
            UriRoutingController routeController = UriRoutingController.create(uriRoutingPath, c, method);
            this.getUriRoutingRegistry().register(uriRoutingPath, routeController);
        }
    }

    private HttpMethod getHttpMethod(Annotation[] annotations) {
        HttpMethod httpMethod = null;
        for (Annotation annotation : annotations) {
            httpMethod = annotation.annotationType().getAnnotation(HttpMethod.class);
            if (httpMethod == null) continue;
            return httpMethod;
        }
        return null;
    }

    public FilterManager getFilterManager() {
        return FilterManager.getInstance();
    }

    public UriRoutingRegistry getUriRoutingRegistry() {
        return UriRoutingRegistry.getInstance();
    }
}

