/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest.util;

import io.netty.util.CharsetUtil;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import mobi.f2time.dorado.rest.MediaType;
import mobi.f2time.dorado.rest.util.TypeUtils;

public final class MediaTypeUtils {
    public static MediaType forType(Class<?> type) {
        if (TypeUtils.isPrimitiveOrWrapper(type) || String.class == type || BigDecimal.class == type || BigInteger.class == type) {
            return MediaType.TEXT_HTML_TYPE.withCharset(CharsetUtil.UTF_8.name());
        }
        if (byte[].class == type || InputStream.class.isAssignableFrom(type)) {
            return MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        if (TypeUtils.isProtobufMessage(type)) {
            return MediaType.APPLICATION_PROTOBUF_TYPE;
        }
        return MediaType.APPLICATION_JSON_TYPE.withCharset(CharsetUtil.UTF_8.name());
    }

    public static MediaType defaultForType(Class<?> type, String defaultType) {
        if ("*/*".equals(defaultType)) {
            return MediaTypeUtils.forType(type);
        }
        return MediaType.valueOf(defaultType);
    }
}

