/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.springboot;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import mobi.f2time.dorado.rest.server.DoradoServer;
import mobi.f2time.dorado.rest.server.DoradoServerBuilder;
import mobi.f2time.dorado.spring.SpringContainer;
import mobi.f2time.dorado.springboot.DoradoConfig;
import mobi.f2time.dorado.springboot.EnableDorado;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;

@Configuration
@ConditionalOnBean(annotation={EnableDorado.class})
@EnableConfigurationProperties(value={DoradoConfig.class})
@Order(value=0x7FFFFFFF)
public class DoradoAutoConfiguration {
    static final Log LOG = LogFactory.getLog((String)"dorado-spring-boot-starter");
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private DoradoConfig config;

    @PostConstruct
    public void startDoradoServer() {
        boolean isSpringBootApp = this.applicationContext.containsBean("springApplicationArguments");
        if (!isSpringBootApp) {
            LOG.info((Object)"Not SpringBoot Application launch, unstart dorado server!");
            return;
        }
        int listenPort = this.config.getPort();
        if (listenPort == 0) {
            throw new IllegalArgumentException("Must be setting dorado.port property");
        }
        DoradoServerBuilder builder = DoradoServerBuilder.forPort(this.config.getPort());
        if (this.config.getAcceptors() > 0) {
            builder.acceptors(this.config.getAcceptors());
        }
        if (this.config.getIoWorkers() > 0) {
            builder.ioWorkers(this.config.getIoWorkers());
        }
        if (this.config.getMinWorkers() > 0 && this.config.getMaxWorkers() > 0) {
            builder.minWorkers(this.config.getMinWorkers()).maxWorkers(this.config.getMaxWorkers());
        }
        if (this.config.getBacklog() > 0) {
            builder.backlog(this.config.getBacklog());
        }
        if (this.config.getMaxConnections() > 0) {
            builder.maxConnection(this.config.getMaxConnections());
        }
        if (this.config.getMaxPendingRequest() > 0) {
            builder.maxPendingRequest(this.config.getMaxPendingRequest());
        }
        if (this.config.getMaxIdleTime() > 0) {
            builder.maxIdleTime(this.config.getMaxIdleTime());
        }
        if (this.config.getSendBuffer() > 0) {
            builder.sendBuffer(this.config.getSendBuffer());
        }
        if (this.config.getRecvBuffer() > 0) {
            builder.recvBuffer(this.config.getRecvBuffer());
        }
        if (this.config.getMaxPacketLength() > 0) {
            builder.maxPacketLength(this.config.getMaxPacketLength());
        }
        String[] scanPackages = null;
        if (this.config.getScanPackages() == null || this.config.getScanPackages().length == 0) {
            scanPackages = this.getSpringBootAppScanPackages();
        }
        builder.scanPackages(scanPackages);
        DoradoServer doradoServer = builder.build();
        SpringContainer.create(this.applicationContext);
        doradoServer.start();
    }

    private String[] getSpringBootAppScanPackages() {
        String[] names;
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)this.applicationContext;
        HashSet<String> packages = new HashSet<String>();
        for (String name : names = registry.getBeanDefinitionNames()) {
            BeanDefinition definition = registry.getBeanDefinition(name);
            if (!(definition instanceof AnnotatedBeanDefinition)) continue;
            AnnotatedBeanDefinition annotatedDefinition = (AnnotatedBeanDefinition)definition;
            this.addComponentScanningPackages(packages, annotatedDefinition.getMetadata());
        }
        return packages.toArray(new String[0]);
    }

    private void addComponentScanningPackages(Set<String> packages, AnnotationMetadata metadata) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(ComponentScan.class.getName(), true));
        if (attributes != null) {
            this.addPackages(packages, attributes.getStringArray("value"));
            this.addPackages(packages, attributes.getStringArray("basePackages"));
            this.addClasses(packages, attributes.getStringArray("basePackageClasses"));
            if (packages.isEmpty()) {
                packages.add(ClassUtils.getPackageName((String)metadata.getClassName()));
            }
        }
    }

    private void addPackages(Set<String> packages, String[] values) {
        if (values != null) {
            Collections.addAll(packages, values);
        }
    }

    private void addClasses(Set<String> packages, String[] values) {
        if (values != null) {
            for (String value : values) {
                packages.add(ClassUtils.getPackageName((String)value));
            }
        }
    }
}

