/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest.http.impl;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.util.CharsetUtil;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mobi.f2time.dorado.rest.http.Cookie;
import mobi.f2time.dorado.rest.http.HttpRequest;
import mobi.f2time.dorado.rest.http.impl.ChannelHolder;
import mobi.f2time.dorado.rest.http.impl.CookieImpl;
import mobi.f2time.dorado.rest.http.impl.InputStreamImpl;
import mobi.f2time.dorado.rest.http.impl.URIParser;

public class HttpRequestImpl
implements HttpRequest {
    private final FullHttpRequest originalRequest;
    private final InputStreamImpl in;
    private final QueryStringDecoder queryStringDecoder;
    private final URIParser uriParser;
    private final Map<String, List<String>> parameters;
    private final HttpHeaders headers;

    public HttpRequestImpl(FullHttpRequest originalHttpRequest) {
        this.originalRequest = originalHttpRequest;
        this.parameters = new HashMap<String, List<String>>();
        this.in = new InputStreamImpl(originalHttpRequest);
        this.queryStringDecoder = new QueryStringDecoder(originalHttpRequest.uri());
        this.parameters.putAll(this.queryStringDecoder.parameters());
        if (originalHttpRequest.method() == HttpMethod.POST) {
            QueryStringDecoder requestParameterDecoder = new QueryStringDecoder(originalHttpRequest.content().toString(CharsetUtil.UTF_8), false);
            this.parameters.putAll(requestParameterDecoder.parameters());
        }
        this.headers = originalHttpRequest.headers();
        this.uriParser = new URIParser();
        this.uriParser.parse(originalHttpRequest.uri());
    }

    @Override
    public String getParameter(String key) {
        List<String> parameterValues = this.parameters.get(key);
        return parameterValues == null || parameterValues.isEmpty() ? null : parameterValues.get(0);
    }

    @Override
    public String[] getParameterValues(String key) {
        return this.parameters.get(key).toArray(new String[0]);
    }

    @Override
    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    @Override
    public String getRemoteAddr() {
        String xForwardFor = this.headers.get("X-Forwarded-For");
        if (xForwardFor == null) {
            InetSocketAddress addr = (InetSocketAddress)ChannelHolder.get().remoteAddress();
            return addr.getAddress().getHostAddress();
        }
        return xForwardFor.split(",")[0];
    }

    @Override
    public Cookie[] getCookies() {
        String cookieString = this.originalRequest.headers().get((CharSequence)HttpHeaderNames.COOKIE);
        if (cookieString != null) {
            Set cookies = ServerCookieDecoder.LAX.decode(cookieString);
            return cookies.stream().map(cookie -> new CookieImpl((io.netty.handler.codec.http.cookie.Cookie)cookie)).collect(Collectors.toList()).toArray(new CookieImpl[0]);
        }
        return null;
    }

    @Override
    public String getHeader(String name) {
        return this.headers.get(name);
    }

    @Override
    public String[] getHeaders(String name) {
        return this.headers.getAll(name).toArray(new String[0]);
    }

    @Override
    public String getQueryString() {
        return this.uriParser.getQueryString();
    }

    @Override
    public String getRequestURI() {
        return this.uriParser.getRequestUri();
    }

    @Override
    public String getMethod() {
        return this.originalRequest.method().name();
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }
}

