/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest.router;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mobi.f2time.dorado.rest.annotation.HttpMethod;

public class UriRoutingPath
implements Comparable<UriRoutingPath> {
    private static final Pattern pathVariablePattern = Pattern.compile("\\{([^{}]*)\\}");
    private static final String defaultPathVariableRegex = "[^/]+";
    private String routingPath;
    private Pattern routingPathPattern;
    private HttpMethod httpMethod;
    private Map<String, Integer> pathVariableIndexHolder = new HashMap<String, Integer>();

    private UriRoutingPath(String routingPath, HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
        this.routingPath = routingPath;
        Matcher matchResult = pathVariablePattern.matcher(routingPath);
        int pathVariableIndex = 0;
        StringBuffer routingPathRegex = new StringBuffer();
        while (matchResult.find()) {
            String pathVariableExpression = matchResult.group(1);
            String[] pathVariableSegments = pathVariableExpression.split(":");
            String pathVariableRegex = pathVariableSegments.length == 2 ? pathVariableSegments[1] : defaultPathVariableRegex;
            String pathVariableName = pathVariableSegments[0];
            matchResult.appendReplacement(routingPathRegex, String.format("(%s)", pathVariableRegex));
            this.pathVariableIndexHolder.put(pathVariableName, pathVariableIndex);
            ++pathVariableIndex;
        }
        matchResult.appendTail(routingPathRegex);
        this.routingPathPattern = Pattern.compile(routingPathRegex.toString());
    }

    public static UriRoutingPath create(String uri, HttpMethod httpMethod) {
        return new UriRoutingPath(uri, httpMethod);
    }

    public Pattern routingPathPattern() {
        return this.routingPathPattern;
    }

    public int resolvePathIndex(String parameterName) {
        Integer pathIndex = this.pathVariableIndexHolder.get(parameterName);
        return pathIndex == null ? -1 : pathIndex;
    }

    public String routingPath() {
        return this.routingPath;
    }

    public String httpMethod() {
        return this.httpMethod == null ? null : this.httpMethod.value();
    }

    public int hashCode() {
        int prime = 31;
        int hash = 1;
        hash = 31 * hash + (this.httpMethod == null ? 0 : this.httpMethod.hashCode());
        hash = 31 * hash + (this.routingPath == null ? 0 : this.routingPath.hashCode());
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UriRoutingPath other = (UriRoutingPath)obj;
        if (this.httpMethod == null ? other.httpMethod != null : !this.httpMethod.equals(other.httpMethod)) {
            return false;
        }
        return !(this.routingPath == null ? other.routingPath != null : !this.routingPath.equals(other.routingPath));
    }

    public String toString() {
        return "UriRoutingPath [routingPath=" + this.routingPath + ", routingPathPattern=" + this.routingPathPattern + ", httpMethod=" + this.httpMethod + ", pathVariableIndexHolder=" + this.pathVariableIndexHolder + "]";
    }

    @Override
    public int compareTo(UriRoutingPath o) {
        int thisPathSegments;
        int targetPathSegments = o.routingPath.split("/").length;
        if (targetPathSegments != (thisPathSegments = this.routingPath.split("/").length)) {
            return targetPathSegments - thisPathSegments;
        }
        return this.pathVariableIndexHolder.size() - o.pathVariableIndexHolder.size();
    }
}

