/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest.util;

import io.netty.util.CharsetUtil;
import java.io.InputStream;
import mobi.f2time.dorado.rest.util.IOUtils;
import mobi.f2time.dorado.rest.util.StringUtils;

public interface TypeConverter<F, T> {
    public static final TypeConverter<String, Integer> STRING_INT = s -> s == null ? null : Integer.valueOf(StringUtils.toInt(s));
    public static final TypeConverter<String, Long> STRING_LONG = s -> s == null ? null : Long.valueOf(StringUtils.toLong(s));
    public static final TypeConverter<String, Float> STRING_FLOAT = s -> s == null ? null : Float.valueOf(StringUtils.toFloat(s));
    public static final TypeConverter<String, Double> STRING_DOUBLE = s -> s == null ? null : Double.valueOf(StringUtils.toDouble(s));
    public static final TypeConverter<String, Short> STRING_SHORT = s -> s == null ? null : Short.valueOf(StringUtils.toShort(s));
    public static final TypeConverter<String, Boolean> STRING_BOOL = s -> s == null ? null : Boolean.valueOf(StringUtils.toBoolean(s));
    public static final TypeConverter<String, Character> STRING_CHAR = s -> {
        throw new UnsupportedOperationException("unsupport convert string to char");
    };
    public static final TypeConverter<String, Byte> STRING_BYTE = s -> {
        throw new UnsupportedOperationException("unsupport convert string to byte");
    };
    public static final TypeConverter<Object, Object> DUMMY = s -> s;
    public static final TypeConverter<InputStream, InputStream> INPUTSTREAM = s -> s;
    public static final TypeConverter<InputStream, String> STRING_UTF8 = s -> IOUtils.toString(s, CharsetUtil.UTF_8.name());
    public static final TypeConverter<String, Float> STRING_FLOAT_WRAPPER = s -> s == null ? null : Float.valueOf(s);
    public static final TypeConverter<String, Integer> STRING_INT_WRAPPER = s -> s == null ? null : Integer.valueOf(s);
    public static final TypeConverter<String, Long> STRING_LONG_WRAPPER = s -> s == null ? null : Long.valueOf(s);
    public static final TypeConverter<String, Double> STRING_DOUBLE_WRAPPER = s -> s == null ? null : Double.valueOf(s);
    public static final TypeConverter<String, Short> STRING_SHORT_WRAPPER = s -> s == null ? null : Short.valueOf(s);
    public static final TypeConverter<String, Boolean> STRING_BOOL_WRAPPER = s -> s == null ? null : Boolean.valueOf(s);
    public static final TypeConverter<String, Character> STRING_CHAR_WRAPPER = s -> {
        throw new UnsupportedOperationException("unsupport convert string to character");
    };
    public static final TypeConverter<String, Byte> STRING_BYTE_WRAPPER = s -> {
        throw new UnsupportedOperationException("unsupport convert string to byte");
    };

    public T convert(F var1);
}

