/*
 * Decompiled with CFR 0.152.
 */
package ai.hypergraph.kaliningraph.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003BG\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00128\b\u0002\u0010\u0006\u001a2\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\u0011\u001a\u0004\u0018\u00018\u00012\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J#\u0010\u0013\u001a\u0004\u0018\u00018\u00012\u0006\u0010\n\u001a\u00028\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014\u00a2\u0006\u0002\u0010\u0015J\u001d\u0010\u0016\u001a\u0004\u0018\u00018\u00012\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\u0004\u0018\u00018\u00012\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\t\u0010\u001b\u001a\u00020\u001cH\u0082\u0010R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000ej\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R>\u0010\u0006\u001a2\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lai/hypergraph/kaliningraph/cache/LRUCache;", "K", "V", "", "maxSize", "", "sizeOf", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "key", "value", "(ILkotlin/jvm/functions/Function2;)V", "map", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "size", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "getOrPut", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "remove", "toString", "", "trimToSize", "", "kaliningraph"})
public final class LRUCache<K, V> {
    private final int maxSize;
    @NotNull
    private final Function2<K, V, Integer> sizeOf;
    @NotNull
    private final LinkedHashMap<K, V> map;
    private int size;

    public LRUCache(int maxSize, @NotNull Function2<? super K, ? super V, Integer> sizeOf) {
        Intrinsics.checkNotNullParameter(sizeOf, (String)"sizeOf");
        this.maxSize = maxSize;
        this.sizeOf = sizeOf;
        this.map = new LinkedHashMap(0, 0.75f);
    }

    public /* synthetic */ LRUCache(int n, Function2 function2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            function2 = 1.INSTANCE;
        }
        this(n, function2);
    }

    @Nullable
    public final V getOrPut(K key, @NotNull Function0<? extends V> value) {
        Object object;
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (((Map)this.map).containsKey(key)) {
            object = this.map.get(key);
        } else {
            Object object2;
            Object it = object2 = value.invoke();
            boolean bl = false;
            this.put(key, it);
            object = object2;
        }
        return object;
    }

    @Nullable
    public final V get(K key) {
        return this.map.get(key);
    }

    @Nullable
    public final V put(K key, V value) {
        V prev2;
        this.size += ((Number)this.sizeOf.invoke(key, value)).intValue();
        V v = prev2 = this.map.put(key, value);
        if (v != null) {
            V it = v;
            boolean bl = false;
            this.size -= ((Number)this.sizeOf.invoke(key, it)).intValue();
        }
        this.trimToSize();
        return prev2;
    }

    @Nullable
    public final V remove(K key) {
        Object prev2;
        Object v = prev2 = this.map.remove(key);
        if (v != null) {
            Object it = v;
            boolean bl = false;
            this.size -= ((Number)this.sizeOf.invoke(key, it)).intValue();
        }
        return prev2;
    }

    private final void trimToSize() {
        LRUCache lRUCache = this;
        while (true) {
            LRUCache lRUCache2 = lRUCache;
            if (lRUCache2.size <= lRUCache2.maxSize || lRUCache2.map.isEmpty()) {
                return;
            }
            Map.Entry<K, V> entry = lRUCache2.map.entrySet().iterator().next();
            Intrinsics.checkNotNullExpressionValue(entry, (String)"map.entries.iterator().next()");
            Map.Entry<K, V> toEvict = entry;
            K key = toEvict.getKey();
            V value = toEvict.getValue();
            lRUCache2.map.remove(key);
            lRUCache2.size -= ((Number)lRUCache2.sizeOf.invoke(key, value)).intValue();
            lRUCache = lRUCache2;
        }
    }

    @NotNull
    public String toString() {
        return "" + this.size + '/' + this.maxSize + " cached=" + this.map;
    }
}

