/*
 * Decompiled with CFR 0.152.
 */
package ai.hypergraph.kaliningraph.tensor;

import ai.hypergraph.kaliningraph.tensor.FreeMatrix;
import ai.hypergraph.kaliningraph.tensor.Matrix;
import ai.hypergraph.kaliningraph.types.Ring;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u000e\b\u0001\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u0003*\u001a\b\u0002\u0010\u0004*\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00002\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u0005B-\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u0012\u0006\u0010\u000b\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\fJ\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0096\u0002J\b\u0010%\u001a\u00020\u0007H\u0016J\b\u0010&\u001a\u00020'H\u0016R\u0016\u0010\u000b\u001a\u00028\u0001X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R9\u0010\u0012\u001a \u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0014\u0012\u0004\u0012\u00020\u00070\u00138VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR!\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001d8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0018\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006("}, d2={"Lai/hypergraph/kaliningraph/tensor/AbstractMatrix;", "T", "A", "Lai/hypergraph/kaliningraph/types/Ring;", "M", "Lai/hypergraph/kaliningraph/tensor/Matrix;", "numRows", "", "numCols", "data", "", "algebra", "(IILjava/util/List;Lai/hypergraph/kaliningraph/types/Ring;)V", "getAlgebra", "()Lai/hypergraph/kaliningraph/types/Ring;", "Lai/hypergraph/kaliningraph/types/Ring;", "getData", "()Ljava/util/List;", "map", "", "Lkotlin/Triple;", "getMap", "()Ljava/util/Map;", "map$delegate", "Lkotlin/Lazy;", "getNumCols", "()I", "getNumRows", "values", "", "getValues", "()Ljava/util/Set;", "values$delegate", "equals", "", "other", "", "hashCode", "toString", "", "kaliningraph"})
public abstract class AbstractMatrix<T, A extends Ring<T>, M extends AbstractMatrix<T, A, M>>
implements Matrix<T, A, M> {
    private final int numRows;
    private final int numCols;
    @NotNull
    private final List<T> data;
    @NotNull
    private final A algebra;
    @NotNull
    private final Lazy values$delegate;
    @NotNull
    private final Lazy map$delegate;

    public AbstractMatrix(int numRows, int numCols, @NotNull List<? extends T> data, @NotNull A algebra) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(algebra, (String)"algebra");
        this.numRows = numRows;
        this.numCols = numCols;
        this.data = data;
        this.algebra = algebra;
        this.values$delegate = LazyKt.lazy((Function0)new Function0<Set<? extends T>>(this){
            final /* synthetic */ AbstractMatrix<T, A, M> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Set<T> invoke() {
                return CollectionsKt.toSet((Iterable)this.this$0.getData());
            }
        });
        this.map$delegate = LazyKt.lazy((Function0)new Function0<Map<Triple<? extends Integer, ? extends Integer, ? extends T>, Integer>>(this){
            final /* synthetic */ AbstractMatrix<T, A, M> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<Triple<Integer, Integer, T>, Integer> invoke() {
                void $this$fold$iv;
                void initial$iv;
                Iterable iterable = this.this$0.getIndices();
                Map map2 = new LinkedHashMap<K, V>();
                AbstractMatrix<T, A, M> abstractMatrix = this.this$0;
                boolean $i$f$fold = false;
                void accumulator$iv = initial$iv;
                for (T element$iv : $this$fold$iv) {
                    int c;
                    void $dstr$r$c;
                    Pair pair = (Pair)element$iv;
                    void map3 = accumulator$iv;
                    boolean bl = false;
                    int r = ((Number)$dstr$r$c.component1()).intValue();
                    T element = abstractMatrix.get(r, c = ((Number)$dstr$r$c.component2()).intValue());
                    if (!Intrinsics.areEqual(element, abstractMatrix.getAlgebra().getNil())) {
                        map3.put(new Triple((Object)r, (Object)c, element), 1);
                    }
                    accumulator$iv = map3;
                }
                return accumulator$iv;
            }
        });
    }

    public /* synthetic */ AbstractMatrix(int n, int n2, List list, Ring ring, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n2 = n;
        }
        this(n, n2, list, ring);
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public int getNumCols() {
        return this.numCols;
    }

    @Override
    @NotNull
    public List<T> getData() {
        return this.data;
    }

    @Override
    @NotNull
    public A getAlgebra() {
        return this.algebra;
    }

    @NotNull
    public final Set<T> getValues() {
        Lazy lazy = this.values$delegate;
        return (Set)lazy.getValue();
    }

    @Override
    @NotNull
    public Map<Triple<Integer, Integer, T>, Integer> getMap() {
        Lazy lazy = this.map$delegate;
        return (Map)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        void $this$foldIndexed$iv;
        Iterator iterator2 = ((Iterable)this.getData()).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        Object it22 = iterator2.next();
        boolean bl = false;
        int it22 = String.valueOf(it22).length() + 2;
        while (iterator2.hasNext()) {
            Object it32 = iterator2.next();
            $i$a$-maxOf-AbstractMatrix$toString$1 = false;
            int it32 = String.valueOf(it32).length() + 2;
            if (it22 >= it32) continue;
            it22 = it32;
        }
        int pad = it22;
        boolean bl2 = false;
        Iterable it32 = this.getData();
        String initial$iv = "";
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        String accumulator$iv = initial$iv;
        for (Object element$iv : $this$foldIndexed$iv) {
            void b;
            void a;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = element$iv;
            String string = accumulator$iv;
            int i = n;
            boolean bl3 = false;
            accumulator$iv = (String)a + StringsKt.padEnd((String)String.valueOf(b), (int)pad, (char)' ') + ' ' + (i > 0 && (i + 1) % this.getNumCols() == 0 ? "\n" : "");
        }
        return accumulator$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (other instanceof FreeMatrix) {
            Object b;
            Pair $dstr$a$b;
            Object a;
            Iterable $this$all$iv = CollectionsKt.zip((Iterable)this.getData(), (Iterable)((FreeMatrix)other).getData());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator2 = $this$all$iv.iterator();
            do {
                if (!iterator2.hasNext()) return true;
                Object element$iv = iterator2.next();
                $dstr$a$b = (Pair)element$iv;
                boolean bl = false;
            } while (Intrinsics.areEqual((Object)(a = $dstr$a$b.component1()), (Object)(b = $dstr$a$b.component2())));
            boolean bl = false;
            if (bl) return true;
        }
        if (!(other instanceof Matrix)) return false;
        if (!Intrinsics.areEqual(((Matrix)other).getData(), this.getData())) return false;
        return true;
    }

    public int hashCode() {
        return ((Object)this.getData()).hashCode();
    }

    @Override
    @NotNull
    public Set<Pair<Integer, Integer>> getIndices() {
        return Matrix.DefaultImpls.getIndices(this);
    }

    @Override
    @NotNull
    public List<List<T>> getRows() {
        return Matrix.DefaultImpls.getRows(this);
    }

    @Override
    @NotNull
    public List<List<T>> getCols() {
        return Matrix.DefaultImpls.getCols(this);
    }

    @Override
    @NotNull
    public M plus(@NotNull M t) {
        return (M)((AbstractMatrix)Matrix.DefaultImpls.plus(this, (Matrix)t));
    }

    @Override
    @NotNull
    public M times(@NotNull M t) {
        return (M)((AbstractMatrix)Matrix.DefaultImpls.times(this, (Matrix)t));
    }

    @Override
    public T dot(@NotNull List<? extends T> $this$dot, @NotNull List<? extends T> es) {
        return Matrix.DefaultImpls.dot(this, $this$dot, es);
    }

    @Override
    @NotNull
    public M join(@NotNull M that, @NotNull Set<Pair<Integer, Integer>> idxs, @NotNull Function2<? super Integer, ? super Integer, ? extends T> op) {
        return (M)((AbstractMatrix)Matrix.DefaultImpls.join(this, (Matrix)that, idxs, op));
    }

    @Override
    public T get(@NotNull Object r, @NotNull Object c) {
        return Matrix.DefaultImpls.get((Matrix)this, r, c);
    }

    @Override
    public T get(int r, int c) {
        return Matrix.DefaultImpls.get((Matrix)this, r, c);
    }

    @Override
    @NotNull
    public List<T> get(int r) {
        return Matrix.DefaultImpls.get((Matrix)this, r);
    }

    @Override
    public int get(@NotNull Triple<Integer, Integer, ? extends T> t) {
        return Matrix.DefaultImpls.get((Matrix)this, t);
    }

    @Override
    @NotNull
    public M transpose() {
        return (M)((AbstractMatrix)Matrix.DefaultImpls.transpose(this));
    }

    @Override
    public void set(@NotNull Triple<Integer, Integer, ? extends T> index2, int i) {
        Matrix.DefaultImpls.set(this, index2, i);
    }

    @Override
    public int count(@NotNull Function1<? super Triple<Integer, Integer, ? extends T>, Boolean> selector) {
        return Matrix.DefaultImpls.count(this, selector);
    }
}

