/*
 * Decompiled with CFR 0.152.
 */
package ai.hypergraph.kaliningraph.image;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0019\u0010\u0010\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0002\u0010\u0014J\u001b\u0010\u0015\u001a\u00020\u00162\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J#\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lai/hypergraph/kaliningraph/image/BMP;", "", "()V", "BMP_CODE", "", "bytes", "", "getBytes", "()[B", "setBytes", "([B)V", "getPadding", "rowLength", "intToByteCouple", "x", "intToFourBytes", "saveBMP", "rgbValues", "", "", "([[I)[B", "saveBitmapData", "", "([[I)V", "saveFileHeader", "saveInfoHeader", "height", "width", "writeLine", "row", "(I[[I)V", "kaliningraph"})
public final class BMP {
    public byte[] bytes;
    private final int BMP_CODE;

    public BMP() {
        this.BMP_CODE = 19778;
    }

    @NotNull
    public final byte[] getBytes() {
        if (this.bytes != null) {
            return this.bytes;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
        return null;
    }

    public final void setBytes(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.bytes = byArray;
    }

    @NotNull
    public final byte[] saveBMP(@NotNull int[][] rgbValues) {
        Intrinsics.checkNotNullParameter((Object)rgbValues, (String)"rgbValues");
        this.setBytes(new byte[54 + 3 * ((Object[])rgbValues).length * rgbValues[0].length + this.getPadding(rgbValues[0].length) * ((Object[])rgbValues).length]);
        this.saveFileHeader();
        this.saveInfoHeader(((Object[])rgbValues).length, rgbValues[0].length);
        this.saveBitmapData(rgbValues);
        return this.getBytes();
    }

    private final void saveFileHeader() {
        byte[] a = this.intToByteCouple(this.BMP_CODE);
        this.getBytes()[0] = a[1];
        this.getBytes()[1] = a[0];
        a = this.intToFourBytes(this.getBytes().length);
        this.getBytes()[5] = a[0];
        this.getBytes()[4] = a[1];
        this.getBytes()[3] = a[2];
        this.getBytes()[2] = a[3];
        this.getBytes()[10] = 54;
    }

    private final void saveInfoHeader(int height, int width) {
        this.getBytes()[14] = 40;
        byte[] a = this.intToFourBytes(width);
        this.getBytes()[22] = a[3];
        this.getBytes()[23] = a[2];
        this.getBytes()[24] = a[1];
        this.getBytes()[25] = a[0];
        a = this.intToFourBytes(height);
        this.getBytes()[18] = a[3];
        this.getBytes()[19] = a[2];
        this.getBytes()[20] = a[1];
        this.getBytes()[21] = a[0];
        this.getBytes()[26] = 1;
        this.getBytes()[28] = 24;
    }

    private final void saveBitmapData(int[][] rgbValues) {
        int n = ((Object[])rgbValues).length;
        for (int i = 0; i < n; ++i) {
            this.writeLine(i, rgbValues);
        }
    }

    private final void writeLine(int row, int[][] rgbValues) {
        int offset = 54;
        int rowLength = rgbValues[row].length;
        int padding = this.getPadding(rgbValues[0].length);
        for (int i = 0; i < rowLength; ++i) {
            int rgb = rgbValues[row][i];
            int temp = offset + 3 * (i + rowLength * row) + row * padding;
            this.getBytes()[temp] = (byte)(rgb >> 16);
            this.getBytes()[temp + 1] = (byte)(rgb >> 8);
            this.getBytes()[temp + 2] = (byte)rgb;
        }
        int temp = offset + 3 * (rowLength - 1 + rowLength * row) + row * padding + 3;
        for (int j = 0; j < padding; ++j) {
            this.getBytes()[temp + j] = 0;
        }
    }

    private final byte[] intToByteCouple(int x) {
        byte[] array = new byte[2];
        array[1] = (byte)x;
        array[0] = (byte)(x >> 8);
        return array;
    }

    private final byte[] intToFourBytes(int x) {
        byte[] array = new byte[4];
        array[3] = (byte)x;
        array[2] = (byte)(x >> 8);
        array[1] = (byte)(x >> 16);
        array[0] = (byte)(x >> 24);
        return array;
    }

    private final int getPadding(int rowLength) {
        int padding = 3 * rowLength % 4;
        if (padding != 0) {
            padding = 4 - padding;
        }
        return padding;
    }
}

