/*
 * Decompiled with CFR 0.152.
 */
package ai.hypergraph.kaliningraph.types;

import ai.hypergraph.kaliningraph.types.GraphKt;
import ai.hypergraph.kaliningraph.types.IEdge;
import ai.hypergraph.kaliningraph.types.IGraph;
import ai.hypergraph.kaliningraph.types.IVertex;
import ai.hypergraph.kaliningraph.types.RandomWalk;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u001a\b\u0000\u0010\u0001*\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u0002*\u001a\b\u0001\u0010\u0003*\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u0005*\u001a\b\u0002\u0010\u0004*\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u00062\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u00000\u0007B!\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00028\u0000\u0012\b\b\u0002\u0010\u000b\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\fJ!\u0010\u001a\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00000\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0013\u0010\n\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000b\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R-\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lai/hypergraph/kaliningraph/types/RandomWalk;", "G", "Lai/hypergraph/kaliningraph/types/IGraph;", "E", "V", "Lai/hypergraph/kaliningraph/types/IEdge;", "Lai/hypergraph/kaliningraph/types/IVertex;", "Lkotlin/sequences/Sequence;", "rand", "Lkotlin/random/Random;", "graph", "head", "(Lkotlin/random/Random;Lai/hypergraph/kaliningraph/types/IGraph;Lai/hypergraph/kaliningraph/types/IVertex;)V", "getGraph", "()Lai/hypergraph/kaliningraph/types/IGraph;", "Lai/hypergraph/kaliningraph/types/IGraph;", "getHead", "()Lai/hypergraph/kaliningraph/types/IVertex;", "Lai/hypergraph/kaliningraph/types/IVertex;", "getRand", "()Lkotlin/random/Random;", "tail", "getTail", "()Lai/hypergraph/kaliningraph/types/RandomWalk;", "tail$delegate", "Lkotlin/Lazy;", "iterator", "", "toString", "", "kaliningraph"})
public final class RandomWalk<G extends IGraph<G, E, V>, E extends IEdge<G, E, V>, V extends IVertex<G, E, V>>
implements Sequence<RandomWalk<G, E, V>> {
    @NotNull
    private final Random rand;
    @NotNull
    private final G graph;
    @NotNull
    private final V head;
    @NotNull
    private final Lazy tail$delegate;

    public RandomWalk(@NotNull Random rand, @NotNull G graph2, @NotNull V head) {
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter(graph2, (String)"graph");
        Intrinsics.checkNotNullParameter(head, (String)"head");
        this.rand = rand;
        this.graph = graph2;
        this.head = head;
        this.tail$delegate = LazyKt.lazy((Function0)new Function0<RandomWalk<G, E, V>>(this){
            final /* synthetic */ RandomWalk<G, E, V> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final RandomWalk<G, E, V> invoke() {
                G g = this.this$0.getGraph();
                Set<E> set2 = GraphKt.getEdgMap(this.this$0.getGraph()).get(this.this$0.getHead());
                Intrinsics.checkNotNull(set2);
                V v = ((IEdge)CollectionsKt.random((Collection)set2, (Random)this.this$0.getRand())).getTarget();
                Random random2 = this.this$0.getRand();
                return new RandomWalk<G, E, V>(random2, g, v);
            }
        });
    }

    public /* synthetic */ RandomWalk(Random random2, IGraph iGraph, IVertex iVertex, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            random2 = (Random)Random.Default;
        }
        if ((n & 4) != 0) {
            iVertex = (IVertex)CollectionsKt.random((Collection)iGraph, (Random)((Random)Random.Default));
        }
        this(random2, iGraph, iVertex);
    }

    @NotNull
    public final Random getRand() {
        return this.rand;
    }

    @NotNull
    public final G getGraph() {
        return this.graph;
    }

    @NotNull
    public final V getHead() {
        return this.head;
    }

    @NotNull
    public final RandomWalk<G, E, V> getTail() {
        Lazy lazy = this.tail$delegate;
        return (RandomWalk)lazy.getValue();
    }

    @NotNull
    public String toString() {
        return this.head.toString();
    }

    @NotNull
    public Iterator<RandomWalk<G, E, V>> iterator() {
        return SequencesKt.generateSequence((Object)this, (Function1)iterator.1.INSTANCE).iterator();
    }
}

