/*
 * Decompiled with CFR 0.152.
 */
package org.kosat.heuristics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kosat.UtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0013\u001a\u00020\u00142\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\tJ\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0002J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0002J\u0006\u0010\u001d\u001a\u00020\tJ\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0002J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\tH\u0002J\u000e\u0010 \u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\tJ\u0018\u0010!\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u0006\u0010\"\u001a\u00020\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lorg/kosat/heuristics/PriorityQueue;", "", "activity", "", "", "(Ljava/util/List;)V", "getActivity", "()Ljava/util/List;", "capacity", "", "heap", "getHeap", "index", "getIndex", "size", "getSize", "()I", "setSize", "(I)V", "buildHeap", "", "cmp", "", "u", "v", "insert", "value", "leftChild", "parent", "pop", "rightChild", "siftDown", "siftUp", "swap", "top", "kaliningraph"})
@SourceDebugExtension(value={"SMAP\nPriorityQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PriorityQueue.kt\norg/kosat/heuristics/PriorityQueue\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n1864#2,3:152\n*S KotlinDebug\n*F\n+ 1 PriorityQueue.kt\norg/kosat/heuristics/PriorityQueue\n*L\n142#1:152,3\n*E\n"})
public final class PriorityQueue {
    @NotNull
    private final List<Double> activity;
    @NotNull
    private final List<Integer> heap;
    @NotNull
    private final List<Integer> index;
    private int capacity;
    private int size;

    public PriorityQueue(@NotNull List<Double> activity) {
        Intrinsics.checkNotNullParameter(activity, (String)"activity");
        this.activity = activity;
        this.heap = new ArrayList();
        this.index = new ArrayList();
        this.capacity = -1;
    }

    @NotNull
    public final List<Double> getActivity() {
        return this.activity;
    }

    @NotNull
    public final List<Integer> getHeap() {
        return this.heap;
    }

    @NotNull
    public final List<Integer> getIndex() {
        return this.index;
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int n) {
        this.size = n;
    }

    private final boolean cmp(int u, int v) {
        if (((Number)this.activity.get(u)).doubleValue() > ((Number)this.activity.get(v)).doubleValue()) {
            return true;
        }
        if (((Number)this.activity.get(u)).doubleValue() < ((Number)this.activity.get(v)).doubleValue()) {
            return false;
        }
        return u < v;
    }

    private final int leftChild(int u) {
        return 2 * u + 1;
    }

    private final int rightChild(int u) {
        return 2 * u + 2;
    }

    private final int parent(int u) {
        return (u - 1) / 2;
    }

    private final void swap(int u, int v) {
        UtilKt.swap(this.heap, u, v);
        this.index.set(((Number)this.heap.get(u)).intValue(), u);
        this.index.set(((Number)this.heap.get(v)).intValue(), v);
    }

    public final void siftUp(int u) {
        int vertex = ((Number)this.heap.get(u)).intValue();
        int curInd = u;
        int parent = this.parent(curInd);
        while (curInd > 0 && this.cmp(vertex, ((Number)this.heap.get(parent)).intValue())) {
            this.heap.set(curInd, this.heap.get(parent));
            this.index.set(((Number)this.heap.get(curInd)).intValue(), curInd);
            curInd = parent;
            parent = this.parent(curInd);
        }
        this.heap.set(curInd, vertex);
        this.index.set(vertex, curInd);
    }

    private final void siftDown(int u) {
        int vertex = ((Number)this.heap.get(u)).intValue();
        int curInd = u;
        int ls = 0;
        int rs = 0;
        int leftVertex = 0;
        int rightVertex = 0;
        while (this.leftChild(curInd) < this.size) {
            ls = this.leftChild(curInd);
            rs = this.rightChild(curInd);
            leftVertex = ls > this.size - 1 ? -1 : ((Number)this.heap.get(ls)).intValue();
            int n = rightVertex = rs > this.size - 1 ? -1 : ((Number)this.heap.get(rs)).intValue();
            if (rs > this.size - 1) {
                if (!this.cmp(leftVertex, vertex)) break;
                this.heap.set(curInd, leftVertex);
                this.index.set(leftVertex, curInd);
                curInd = ls;
                continue;
            }
            if (this.cmp(leftVertex, rightVertex)) {
                if (!this.cmp(leftVertex, vertex)) break;
                this.heap.set(curInd, leftVertex);
                this.index.set(leftVertex, curInd);
                curInd = ls;
                continue;
            }
            if (!this.cmp(rightVertex, vertex)) break;
            this.heap.set(curInd, rightVertex);
            this.index.set(rightVertex, curInd);
            curInd = rs;
        }
        this.heap.set(curInd, vertex);
        this.index.set(vertex, curInd);
    }

    public final int top() {
        if (!(this.size != 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return ((Number)this.heap.get(0)).intValue();
    }

    public final int pop() {
        if (!(this.size != 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int max = this.top();
        this.swap(0, this.size - 1);
        this.index.set(((Number)this.heap.get(this.size - 1)).intValue(), -1);
        int n = this.size;
        this.size = n + -1;
        if (!((Collection)this.heap).isEmpty()) {
            this.siftDown(0);
        }
        return max;
    }

    public final void insert(int value) {
        if (!(this.size != this.capacity)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.heap.set(this.size, value);
        this.index.set(value, this.size);
        int n = this.size;
        this.size = n + 1;
        this.siftUp(this.size - 1);
    }

    /*
     * WARNING - void declaration
     */
    public final void buildHeap(@NotNull List<Double> activity) {
        Intrinsics.checkNotNullParameter(activity, (String)"activity");
        int ind = 0;
        int n = CollectionsKt.getLastIndex(activity);
        if (ind <= n) {
            while (true) {
                this.heap.add(ind);
                if (ind == n) break;
                ++ind;
            }
        }
        this.size = this.heap.size();
        while (this.index.size() < this.size) {
            this.index.add(0);
        }
        Iterable $this$forEachIndexed$iv = this.heap;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void elem;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n3 = ((Number)item$iv).intValue();
            int ind2 = n2;
            boolean bl = false;
            this.index.set((int)elem, ind2);
        }
        for (ind = this.heap.size() / 2; -1 < ind; --ind) {
            this.siftDown(ind);
        }
        this.capacity = this.size;
    }
}

