/*
 * Decompiled with CFR 0.152.
 */
package org.kosat.heuristics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kosat.CDCL;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\b\b\u0002\u0010\r\u001a\u00020\bH\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/kosat/heuristics/Restarter;", "", "solver", "Lorg/kosat/CDCL;", "(Lorg/kosat/CDCL;)V", "lubyMultiplierConstant", "", "lubyPosition", "", "numberOfConflictsAfterRestart", "restartNumber", "luby", "i", "initialDeg", "restart", "", "update", "kaliningraph"})
public final class Restarter {
    @NotNull
    private final CDCL solver;
    private final double lubyMultiplierConstant;
    private double restartNumber;
    private int numberOfConflictsAfterRestart;
    private int lubyPosition;

    public Restarter(@NotNull CDCL solver2) {
        Intrinsics.checkNotNullParameter((Object)solver2, (String)"solver");
        this.solver = solver2;
        this.restartNumber = this.lubyMultiplierConstant = 50.0;
        this.lubyPosition = 1;
    }

    private final int luby(int i, int initialDeg) {
        int deg;
        if (i == 2) {
            return 1;
        }
        for (deg = initialDeg; deg <= i; deg *= 2) {
        }
        while (deg / 2 > i) {
            deg /= 2;
        }
        if (deg - 1 == i) {
            return deg / 2;
        }
        return this.luby(i - deg / 2 + 1, deg / 2);
    }

    static /* synthetic */ int luby$default(Restarter restarter, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 1;
        }
        return restarter.luby(n, n2);
    }

    public final void restart() {
        int n = this.lubyPosition;
        this.lubyPosition = n + 1;
        this.restartNumber = this.lubyMultiplierConstant * (double)Restarter.luby$default(this, n, 0, 2, null);
        this.solver.reset();
    }

    public final void update() {
        int n = this.numberOfConflictsAfterRestart;
        this.numberOfConflictsAfterRestart = n + 1;
        if ((double)this.numberOfConflictsAfterRestart >= this.restartNumber) {
            this.numberOfConflictsAfterRestart = 0;
            this.restart();
        }
    }
}

