/*
 * Decompiled with CFR 0.152.
 */
package org.kosat.heuristics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kosat.CDCL;
import org.kosat.CDCLKt;
import org.kosat.Clause;
import org.kosat.VarState;
import org.kosat.VarValue;
import org.kosat.heuristics.PriorityQueue;
import org.kosat.heuristics.VariableSelector;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0016\u0010\u0014\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0016\u0010\u0018\u001a\u00020\u00032\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0016H\u0002J\u001e\u0010\u001b\u001a\u00020\u00032\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00162\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0017H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/kosat/heuristics/VSIDS;", "Lorg/kosat/heuristics/VariableSelector;", "numberOfVariables", "", "solver", "Lorg/kosat/CDCL;", "(ILorg/kosat/CDCL;)V", "activity", "", "", "activityInc", "activityLimit", "activityPQ", "Lorg/kosat/heuristics/PriorityQueue;", "multiplier", "numberOfConflicts", "addVariable", "", "backTrack", "variable", "build", "clauses", "", "Lorg/kosat/Clause;", "getMaxActivityVariable", "vars", "Lorg/kosat/VarState;", "nextDecision", "level", "update", "lemma", "kaliningraph"})
@SourceDebugExtension(value={"SMAP\nVariableSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VariableSelector.kt\norg/kosat/heuristics/VSIDS\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,199:1\n1855#2:200\n1864#2,3:201\n1856#2:204\n1855#2:205\n1855#2,2:206\n1856#2:208\n1747#2,3:209\n288#2,2:212\n*S KotlinDebug\n*F\n+ 1 VariableSelector.kt\norg/kosat/heuristics/VSIDS\n*L\n37#1:200\n44#1:201,3\n37#1:204\n64#1:205\n65#1:206,2\n64#1:208\n74#1:209,3\n78#1:212,2\n*E\n"})
public final class VSIDS
extends VariableSelector {
    private int numberOfVariables;
    @NotNull
    private final CDCL solver;
    private final double multiplier;
    private int numberOfConflicts;
    private double activityInc;
    private double activityLimit;
    @NotNull
    private final List<Double> activity;
    @NotNull
    private PriorityQueue activityPQ;

    public VSIDS(int numberOfVariables, @NotNull CDCL solver2) {
        Intrinsics.checkNotNullParameter((Object)solver2, (String)"solver");
        this.numberOfVariables = numberOfVariables;
        this.solver = solver2;
        this.multiplier = 1.1;
        this.activityInc = 1.0;
        this.activityLimit = 1.0E100;
        this.activity = new ArrayList();
        this.activityPQ = new PriorityQueue(this.activity);
    }

    public /* synthetic */ VSIDS(int n, CDCL cDCL, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n, cDCL);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(@NotNull Clause lemma) {
        Intrinsics.checkNotNullParameter((Object)lemma, (String)"lemma");
        Iterable $this$forEach$iv = lemma;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int lit = ((Number)element$iv).intValue();
            boolean bl = false;
            int v = CDCLKt.variable(lit);
            List<Double> list = this.activity;
            list.set(v, ((Number)list.get(v)).doubleValue() + this.activityInc);
            if (((Number)this.activityPQ.getIndex().get(v)).intValue() != -1) {
                this.activityPQ.siftUp(((Number)this.activityPQ.getIndex().get(v)).intValue());
            }
            if (!(((Number)this.activity.get(v)).doubleValue() > this.activityLimit)) continue;
            Iterable $this$forEachIndexed$iv = this.activity;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void value;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                double d2 = ((Number)item$iv).doubleValue();
                int ind = n;
                boolean bl2 = false;
                this.activity.set(ind, (double)(value / this.activityLimit));
            }
            this.activityInc /= this.activityLimit;
        }
        this.activityInc *= this.multiplier;
        int n = this.numberOfConflicts;
        this.numberOfConflicts = n + 1;
    }

    @Override
    public void addVariable() {
        this.activity.add(0.0);
        int n = this.numberOfVariables;
        this.numberOfVariables = n + 1;
    }

    @Override
    public void build(@NotNull List<Clause> clauses) {
        Intrinsics.checkNotNullParameter(clauses, (String)"clauses");
        while (this.activity.size() < this.numberOfVariables) {
            this.activity.add(0.0);
        }
        Iterable $this$forEach$iv = clauses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Clause clause = (Clause)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = clause;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                int lit = ((Number)element$iv2).intValue();
                boolean bl2 = false;
                List<Double> list = this.activity;
                int n = CDCLKt.variable(lit);
                list.set(n, ((Number)list.get(n)).doubleValue() + this.activityInc);
            }
        }
        this.activityPQ.buildHeap(this.activity);
    }

    @Override
    public int nextDecision(@NotNull List<VarState> vars, int level) {
        Object v1;
        block6: {
            boolean bl;
            block5: {
                Intrinsics.checkNotNullParameter(vars, (String)"vars");
                Iterable $this$any$iv = this.getAssumptions();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        int it = ((Number)element$iv).intValue();
                        boolean bl2 = false;
                        if (!(this.solver.getValue(it) == VarValue.FALSE)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return -1;
            }
            Iterable $this$firstOrNull$iv = this.getAssumptions();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl3 = false;
                if (!(this.solver.getValue(it) == VarValue.UNDEFINED)) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        Integer n = v1;
        return n != null ? n : this.getMaxActivityVariable(vars) * 2;
    }

    @Override
    public void backTrack(int variable) {
        if (((Number)this.activityPQ.getIndex().get(variable)).intValue() == -1) {
            this.activityPQ.insert(variable);
        }
    }

    private final int getMaxActivityVariable(List<VarState> vars) {
        int v = 0;
        do {
            if (this.activityPQ.getSize() > 0) continue;
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        } while (vars.get(v = this.activityPQ.pop()).getValue() != VarValue.UNDEFINED);
        return v;
    }
}

