/*
 * Decompiled with CFR 0.152.
 */
package org.kosat.heuristics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kosat.CDCL;
import org.kosat.CDCLKt;
import org.kosat.Clause;
import org.kosat.VarState;
import org.kosat.VarValue;
import org.kosat.heuristics.VariableSelector;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0016\u0010\u0013\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u001a\u0010\u0017\u001a\u00060\u0003j\u0002`\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0015H\u0002J\"\u0010\u001b\u001a\u00060\u0003j\u0002`\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00152\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0016H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/kosat/heuristics/VsidsWithoutQueue;", "Lorg/kosat/heuristics/VariableSelector;", "numberOfVariables", "", "solver", "Lorg/kosat/CDCL;", "(ILorg/kosat/CDCL;)V", "activity", "", "", "activityInc", "activityLimit", "decay", "multiplier", "numberOfConflicts", "addVariable", "", "backTrack", "variable", "build", "clauses", "", "Lorg/kosat/Clause;", "getMaxActivityVariable", "Lorg/kosat/Lit;", "vars", "Lorg/kosat/VarState;", "nextDecision", "level", "update", "lemma", "kaliningraph"})
@SourceDebugExtension(value={"SMAP\nVariableSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VariableSelector.kt\norg/kosat/heuristics/VsidsWithoutQueue\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,199:1\n1855#2,2:200\n1864#2,3:202\n1855#2:205\n1855#2,2:206\n1856#2:208\n1747#2,3:209\n288#2,2:212\n*S KotlinDebug\n*F\n+ 1 VariableSelector.kt\norg/kosat/heuristics/VsidsWithoutQueue\n*L\n139#1:200,2\n150#1:202,3\n167#1:205\n168#1:206,2\n167#1:208\n175#1:209,3\n179#1:212,2\n*E\n"})
public final class VsidsWithoutQueue
extends VariableSelector {
    private int numberOfVariables;
    @NotNull
    private final CDCL solver;
    private final int decay;
    private final double multiplier;
    private final double activityLimit;
    private double activityInc;
    private int numberOfConflicts;
    @NotNull
    private final List<Double> activity;

    public VsidsWithoutQueue(int numberOfVariables, @NotNull CDCL solver2) {
        Intrinsics.checkNotNullParameter((Object)solver2, (String)"solver");
        this.numberOfVariables = numberOfVariables;
        this.solver = solver2;
        this.decay = 50;
        this.multiplier = 2.0;
        this.activityLimit = 1.0E100;
        this.activityInc = 1.0;
        this.activity = new ArrayList();
    }

    public /* synthetic */ VsidsWithoutQueue(int n, CDCL cDCL, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n, cDCL);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(@NotNull Clause lemma) {
        Intrinsics.checkNotNullParameter((Object)lemma, (String)"lemma");
        Iterable $this$forEach$iv22 = lemma;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv22) {
            int lit = ((Number)element$iv).intValue();
            boolean bl = false;
            int v = CDCLKt.variable(lit);
            List<Double> list = this.activity;
            list.set(v, ((Number)list.get(v)).doubleValue() + this.activityInc);
        }
        int $this$forEach$iv22 = this.numberOfConflicts;
        this.numberOfConflicts = $this$forEach$iv22 + 1;
        if (this.numberOfConflicts == this.decay) {
            this.activityInc *= this.multiplier;
            this.numberOfConflicts = 0;
            if (this.activityInc > this.activityLimit) {
                Iterable $this$forEachIndexed$iv = this.activity;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void value;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    double v = ((Number)item$iv).doubleValue();
                    int ind = n;
                    boolean bl = false;
                    this.activity.set(ind, (double)(value / this.activityInc));
                }
                this.activityInc = 1.0;
            }
        }
    }

    @Override
    public void addVariable() {
        this.activity.add(0.0);
        int n = this.numberOfVariables;
        this.numberOfVariables = n + 1;
    }

    @Override
    public void build(@NotNull List<Clause> clauses) {
        Intrinsics.checkNotNullParameter(clauses, (String)"clauses");
        while (this.activity.size() < this.numberOfVariables) {
            this.activity.add(0.0);
        }
        Iterable $this$forEach$iv = clauses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Clause clause = (Clause)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = clause;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                int lit = ((Number)element$iv2).intValue();
                boolean bl2 = false;
                List<Double> list = this.activity;
                int n = CDCLKt.variable(lit);
                list.set(n, ((Number)list.get(n)).doubleValue() + this.activityInc);
            }
        }
    }

    @Override
    public int nextDecision(@NotNull List<VarState> vars, int level) {
        Object v1;
        block6: {
            boolean bl;
            block5: {
                Intrinsics.checkNotNullParameter(vars, (String)"vars");
                Iterable $this$any$iv = this.getAssumptions();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        int it = ((Number)element$iv).intValue();
                        boolean bl2 = false;
                        if (!(this.solver.getValue(it) == VarValue.FALSE)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return -1;
            }
            Iterable $this$firstOrNull$iv = this.getAssumptions();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl3 = false;
                if (!(this.solver.getValue(it) == VarValue.UNDEFINED)) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        Integer n = v1;
        return n != null ? n : this.getMaxActivityVariable(vars) * 2;
    }

    @Override
    public void backTrack(int variable) {
    }

    private final int getMaxActivityVariable(List<VarState> vars) {
        int v = -1;
        double max = -1.0;
        int n = this.numberOfVariables;
        for (int i = 0; i < n; ++i) {
            if (vars.get(i).getValue() != VarValue.UNDEFINED || !(max < ((Number)this.activity.get(i)).doubleValue())) continue;
            v = i;
            max = ((Number)this.activity.get(i)).doubleValue();
        }
        return v;
    }
}

