// This file was generated by Shipshape

package ai.hypergraph.kotlingrad.typelevel

import ai.hypergraph.kaliningraph.graphs.*
import kotlin.jvm.JvmName

typealias OOO = Ex<OO, OO, OO>
typealias OOX = Ex<OO, OO, XX>
typealias OXO = Ex<OO, XX, OO>
typealias OXX = Ex<OO, XX, XX>
typealias XOO = Ex<XX, OO, OO>
typealias XOX = Ex<XX, OO, XX>
typealias XXO = Ex<XX, XX, OO>
typealias XXX = Ex<XX, XX, XX>


/**
 * The following code is a type-level encoding of the 3-element graded poset.
 *
 * For combination, i.e. any arithmetical operation, where P is a constant:
 *
 *        |    P      x      y      z      xy      xz      yz      xyz
 *    ----------------------------------------------------------------
 *    P   |    P      x      y      z      xy      xz      yz      xyz
 *    x   |    x      x      xy     xz     xy      xz      xyz     xyz
 *    y   |    y      xy     y      yz     xy      xyz     yz      xyz
 *    z   |    z      xz     yz     z      xyz     xz      yz      xyz
 *    xy  |    xy     xy     xy     xyz    xy      xyz     xyz     xyz
 *    xz  |    xz     xz     xyz    xz     xyz     xz      xyz     xyz
 *    yz  |    yz     xyz    yz     yz     xyz     xyz     yz      xyz
 *    xyz |    xyz    xyz    xyz    xyz    xyz     xyz     xyz     xyz
 *
 * Can be viewed as a Hasse Diagram: https://en.wikipedia.org/wiki/Hasse_diagram
 *
 * For application/invocation, where P is a constant:
 *
 *       |     P      x      y      z      xy      xz      yz      xyz
 *   -----------------------------------------------------------------
 *   P   |     P
 *   x   |            P                    y       z               yz
 *   y   |                   P             x               z       xz
 *   z   |                          P              x       y       xy
 *   xy  |            y      x             P                       z
 *   xz  |            z             x              P               y
 *   yz  |                   z      y                      P       x
 *   xyz |            yz     xz     xy     z       y       x       P
 */

@JvmName("plus:___") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.plus(e: OOO) = Ex<V0, V1, V2>(Ops.sum, null, this, e)
@JvmName("plus:__t") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.plus(e: OOX) = Ex<V0, V1, XX>(Ops.sum, null, this, e)
@JvmName("plus:_t_") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.plus(e: OXO) = Ex<V0, XX, V2>(Ops.sum, null, this, e)
@JvmName("plus:_tt") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.plus(e: OXX) = Ex<V0, XX, XX>(Ops.sum, null, this, e)
@JvmName("plus:t__") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.plus(e: XOO) = Ex<XX, V1, V2>(Ops.sum, null, this, e)
@JvmName("plus:t_t") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.plus(e: XOX) = Ex<XX, V1, XX>(Ops.sum, null, this, e)
@JvmName("plus:tt_") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.plus(e: XXO) = Ex<XX, XX, V2>(Ops.sum, null, this, e)
@JvmName("plus:ttt") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.plus(e: XXX) = Ex<XX, XX, XX>(Ops.sum, null, this, e)
operator fun <N: Number, V0: XO, V1: XO, V2: XO> N.plus(e: Ex<V0, V1, V2>) = Ex<V0, V1, V2>(Ops.sum, null, Nt(this), e)
operator fun <N: Number, V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.plus(n: N) = Ex<V0, V1, V2>(Ops.sum, null, this, Nt(n))

@JvmName("minus:___") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.minus(e: OOO) = Ex<V0, V1, V2>(Ops.sub, null, this, e)
@JvmName("minus:__t") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.minus(e: OOX) = Ex<V0, V1, XX>(Ops.sub, null, this, e)
@JvmName("minus:_t_") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.minus(e: OXO) = Ex<V0, XX, V2>(Ops.sub, null, this, e)
@JvmName("minus:_tt") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.minus(e: OXX) = Ex<V0, XX, XX>(Ops.sub, null, this, e)
@JvmName("minus:t__") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.minus(e: XOO) = Ex<XX, V1, V2>(Ops.sub, null, this, e)
@JvmName("minus:t_t") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.minus(e: XOX) = Ex<XX, V1, XX>(Ops.sub, null, this, e)
@JvmName("minus:tt_") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.minus(e: XXO) = Ex<XX, XX, V2>(Ops.sub, null, this, e)
@JvmName("minus:ttt") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.minus(e: XXX) = Ex<XX, XX, XX>(Ops.sub, null, this, e)
operator fun <N: Number, V0: XO, V1: XO, V2: XO> N.minus(e: Ex<V0, V1, V2>) = Ex<V0, V1, V2>(Ops.sub, null, Nt(this), e)
operator fun <N: Number, V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.minus(n: N) = Ex<V0, V1, V2>(Ops.sub, null, this, Nt(n))

@JvmName("times:___") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.times(e: OOO) = Ex<V0, V1, V2>(Ops.prod, null, this, e)
@JvmName("times:__t") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.times(e: OOX) = Ex<V0, V1, XX>(Ops.prod, null, this, e)
@JvmName("times:_t_") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.times(e: OXO) = Ex<V0, XX, V2>(Ops.prod, null, this, e)
@JvmName("times:_tt") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.times(e: OXX) = Ex<V0, XX, XX>(Ops.prod, null, this, e)
@JvmName("times:t__") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.times(e: XOO) = Ex<XX, V1, V2>(Ops.prod, null, this, e)
@JvmName("times:t_t") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.times(e: XOX) = Ex<XX, V1, XX>(Ops.prod, null, this, e)
@JvmName("times:tt_") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.times(e: XXO) = Ex<XX, XX, V2>(Ops.prod, null, this, e)
@JvmName("times:ttt") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.times(e: XXX) = Ex<XX, XX, XX>(Ops.prod, null, this, e)
operator fun <N: Number, V0: XO, V1: XO, V2: XO> N.times(e: Ex<V0, V1, V2>) = Ex<V0, V1, V2>(Ops.prod, null, Nt(this), e)
operator fun <N: Number, V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.times(n: N) = Ex<V0, V1, V2>(Ops.prod, null, this, Nt(n))

@JvmName("div:___") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.div(e: OOO) = Ex<V0, V1, V2>(Ops.ratio, null, this, e)
@JvmName("div:__t") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.div(e: OOX) = Ex<V0, V1, XX>(Ops.ratio, null, this, e)
@JvmName("div:_t_") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.div(e: OXO) = Ex<V0, XX, V2>(Ops.ratio, null, this, e)
@JvmName("div:_tt") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.div(e: OXX) = Ex<V0, XX, XX>(Ops.ratio, null, this, e)
@JvmName("div:t__") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.div(e: XOO) = Ex<XX, V1, V2>(Ops.ratio, null, this, e)
@JvmName("div:t_t") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.div(e: XOX) = Ex<XX, V1, XX>(Ops.ratio, null, this, e)
@JvmName("div:tt_") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.div(e: XXO) = Ex<XX, XX, V2>(Ops.ratio, null, this, e)
@JvmName("div:ttt") operator fun <V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.div(e: XXX) = Ex<XX, XX, XX>(Ops.ratio, null, this, e)
operator fun <N: Number, V0: XO, V1: XO, V2: XO> N.div(e: Ex<V0, V1, V2>) = Ex<V0, V1, V2>(Ops.ratio, null, Nt(this), e)
operator fun <N: Number, V0: XO, V1: XO, V2: XO> Ex<V0, V1, V2>.div(n: N) = Ex<V0, V1, V2>(Ops.ratio, null, this, Nt(n))

@JvmName("i:__t") operator fun <N: Number> OOX.invoke(v3: V3Bnd<N>) = call(v3)
@JvmName("i:_t_") operator fun <N: Number> OXO.invoke(v2: V2Bnd<N>) = call(v2)
@JvmName("i:_tt") operator fun <N: Number> OXX.invoke(v2: V2Bnd<N>) = inv<N, OOX>(v2)
@JvmName("i:_tt") operator fun <N: Number> OXX.invoke(v3: V3Bnd<N>) = inv<N, OXO>(v3)
@JvmName("i:_tt") operator fun <N: Number> OXX.invoke(v2: V2Bnd<N>, v3: V3Bnd<N>) = call(v2, v3)
@JvmName("i:t__") operator fun <N: Number> XOO.invoke(v1: V1Bnd<N>) = call(v1)
@JvmName("i:t_t") operator fun <N: Number> XOX.invoke(v1: V1Bnd<N>) = inv<N, OOX>(v1)
@JvmName("i:t_t") operator fun <N: Number> XOX.invoke(v3: V3Bnd<N>) = inv<N, XOO>(v3)
@JvmName("i:t_t") operator fun <N: Number> XOX.invoke(v1: V1Bnd<N>, v3: V3Bnd<N>) = call(v1, v3)
@JvmName("i:tt_") operator fun <N: Number> XXO.invoke(v1: V1Bnd<N>) = inv<N, OXO>(v1)
@JvmName("i:tt_") operator fun <N: Number> XXO.invoke(v2: V2Bnd<N>) = inv<N, XOO>(v2)
@JvmName("i:tt_") operator fun <N: Number> XXO.invoke(v1: V1Bnd<N>, v2: V2Bnd<N>) = call(v1, v2)
@JvmName("i:ttt") operator fun <N: Number> XXX.invoke(v1: V1Bnd<N>) = inv<N, OXX>(v1)
@JvmName("i:ttt") operator fun <N: Number> XXX.invoke(v2: V2Bnd<N>) = inv<N, XOX>(v2)
@JvmName("i:ttt") operator fun <N: Number> XXX.invoke(v1: V1Bnd<N>, v2: V2Bnd<N>) = inv<N, OOX>(v1, v2)
@JvmName("i:ttt") operator fun <N: Number> XXX.invoke(v3: V3Bnd<N>) = inv<N, XXO>(v3)
@JvmName("i:ttt") operator fun <N: Number> XXX.invoke(v1: V1Bnd<N>, v3: V3Bnd<N>) = inv<N, OXO>(v1, v3)
@JvmName("i:ttt") operator fun <N: Number> XXX.invoke(v2: V2Bnd<N>, v3: V3Bnd<N>) = inv<N, XOO>(v2, v3)
@JvmName("i:ttt") operator fun <N: Number> XXX.invoke(v1: V1Bnd<N>, v2: V2Bnd<N>, v3: V3Bnd<N>) = call(v1, v2, v3)