/*
 * Decompiled with CFR 0.152.
 */
package ai.hypergraph.kotlingrad.api;

import ai.hypergraph.kotlingrad.api.MFun;
import ai.hypergraph.kotlingrad.api.Mat;
import ai.hypergraph.kotlingrad.api.NilFun;
import ai.hypergraph.kotlingrad.api.SFun;
import ai.hypergraph.kotlingrad.api.VFun;
import ai.hypergraph.kotlingrad.api.Vec;
import ai.hypergraph.kotlingrad.shapes.D1;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00042\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050\u00062\b\u0012\u0004\u0012\u0002H\u00010\u0007B3\b\u0016\u0012*\u0010\b\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\n0\t\"\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u001f\u0012\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010%\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\r2\u0006\u0010&\u001a\u00020\u0018H\u0086\u0002J\u001f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u0018H\u0086\u0002J:\u0010(\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u001e\u0010)\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020*H\u0016J\u0018\u0010+\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\n0\fJ5\u0010,\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00062\u0018\u0010-\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0006H\u0096\u0002J\u0014\u0010.\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\rH\u0016J?\u0010/\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u0002H00\u0006\"\b\b\u0003\u00100*\u00020\u00042\u0018\u00101\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u0002H00\u0006H\u0096\u0002J)\u0010/\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\f\u00101\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0096\u0002J)\u0010/\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\r2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\rH\u0096\u0002J\u001b\u00102\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0000H\u0096\u0002R-\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\r0\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R'\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0013\u001a\u0004\b\u0015\u0010\u0011R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u001b\u0010\u001a\u001a\u00020\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0013\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001e\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001cR&\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0011R-\u0010!\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00010\u00008VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u0013\u001a\u0004\b\"\u0010#\u00a8\u00063"}, d2={"Lai/hypergraph/kotlingrad/api/Mat;", "X", "Lai/hypergraph/kotlingrad/api/SFun;", "R", "Lai/hypergraph/kotlingrad/shapes/D1;", "C", "Lai/hypergraph/kotlingrad/api/MFun;", "Lai/hypergraph/kotlingrad/api/NilFun;", "rows", "", "Lai/hypergraph/kotlingrad/api/Vec;", "([Lai/hypergraph/kotlingrad/api/Vec;)V", "", "Lai/hypergraph/kotlingrad/api/VFun;", "(Ljava/util/List;)V", "cols", "getCols", "()Ljava/util/List;", "cols$delegate", "Lkotlin/Lazy;", "flattened", "getFlattened", "flattened$delegate", "indices", "", "getIndices", "numCols", "getNumCols", "()I", "numCols$delegate", "numRows", "getNumRows", "getRows", "\u1d40", "get\u1d40", "()Lai/hypergraph/kotlingrad/api/Mat;", "\u1d40$delegate", "get", "i", "j", "map", "ef", "Lkotlin/Function1;", "materialize", "plus", "addend", "sum", "times", "Q", "multiplicand", "unaryMinus", "kotlingrad"})
public class Mat<X extends SFun<X>, R extends D1, C extends D1>
extends MFun<X, R, C>
implements NilFun<X> {
    @NotNull
    private final List<VFun<X, C>> rows;
    @NotNull
    private final Lazy flattened$delegate;
    private final int numRows;
    @NotNull
    private final Lazy numCols$delegate;
    @NotNull
    private final List<Integer> indices;
    @NotNull
    private final Lazy cols$delegate;
    @NotNull
    private final Lazy \u1d40$delegate;

    public Mat(@NotNull List<? extends VFun<X, C>> rows) {
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        Collection $this$toTypedArray$iv = rows;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        VFun[] vFunArray = thisCollection$iv.toArray(new VFun[0]);
        if (vFunArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        VFun[] vFunArray2 = vFunArray;
        super(Arrays.copyOf(vFunArray2, vFunArray2.length));
        this.rows = rows;
        this.flattened$delegate = LazyKt.lazy((Function0)new Function0<List<? extends SFun<X>>>(this){
            final /* synthetic */ Mat<X, R, C> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<SFun<X>> invoke() {
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = this.this$0.materialize();
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    Vec it = (Vec)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = it.getContents();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        });
        this.numRows = this.getRows().size();
        this.numCols$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ Mat<X, R, C> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return ((Vec)((VFun)CollectionsKt.first(this.this$0.getRows())).invoke()).getSize();
            }
        }));
        this.indices = CollectionsKt.toList((Iterable)((Iterable)CollectionsKt.getIndices((Collection)this.getRows())));
        this.cols$delegate = LazyKt.lazy((Function0)new Function0<List<? extends Vec<X, R>>>(this){
            final /* synthetic */ Mat<X, R, C> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Vec<X, R>> invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = (Iterable)RangesKt.until((int)0, (int)this.this$0.getNumCols());
                Mat<X, R, C> mat = this.this$0;
                boolean $i$f$map = false;
                void var4_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void $this$mapTo$iv$iv2;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Iterable $this$map$iv2 = mat.materialize();
                    boolean $i$f$map2 = false;
                    Iterable iterable2 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (T item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void i;
                        void it;
                        Vec vec = (Vec)item$iv$iv2;
                        Collection collection2 = destination$iv$iv2;
                        boolean bl2 = false;
                        collection2.add(it.get((int)i));
                    }
                    List list = (List)destination$iv$iv2;
                    collection.add(new Vec<X, E>(list));
                }
                return (List)destination$iv$iv;
            }
        });
        this.\u1d40$delegate = LazyKt.lazy((Function0)new Function0<Mat<X, C, R>>(this){
            final /* synthetic */ Mat<X, R, C> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Mat<X, C, R> invoke() {
                return new Mat<X, R, R>(this.this$0.getCols());
            }
        });
    }

    @NotNull
    public List<VFun<X, C>> getRows() {
        return this.rows;
    }

    public Mat(Vec<X, C> ... rows) {
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        this(ArraysKt.asList((Object[])rows));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Vec<X, C>> materialize() {
        void $this$filterTo$iv$iv;
        List list;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getRows();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VFun vFun = (VFun)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            collection.add(it.invoke());
        }
        List rows = list = (List)destination$iv$iv;
        boolean bl = false;
        Iterable $this$filter$iv = CollectionsKt.zip((Iterable)((Iterable)CollectionsKt.getIndices((Collection)rows)), (Iterable)rows);
        boolean $i$f$filter = false;
        Iterable iterable2 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl2 = false;
            if (!(((Vec)it.getSecond()).getSize() != this.getNumCols())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List $this$materialize_u24lambda_u2d6_u24lambda_u2d5 = (List)destination$iv$iv2;
        boolean bl3 = false;
        if (!$this$materialize_u24lambda_u2d6_u24lambda_u2d5.isEmpty()) {
            Collection<Vec> collection;
            Pair it;
            Collection<Integer> collection2;
            Iterable $this$mapTo$iv$iv2;
            Iterable $this$map$iv2;
            boolean bl4 = false;
            Iterable bl5 = $this$materialize_u24lambda_u2d6_u24lambda_u2d5;
            int n = this.getNumCols();
            boolean $i$f$map2 = false;
            void bl2 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Pair pair = (Pair)item$iv$iv;
                collection2 = destination$iv$iv3;
                boolean bl6 = false;
                collection2.add(((Number)it.getFirst()).intValue());
            }
            collection2 = (List)destination$iv$iv3;
            $this$map$iv2 = $this$materialize_u24lambda_u2d6_u24lambda_u2d5;
            $i$f$map2 = false;
            $this$mapTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (Pair)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl7 = false;
                collection.add((Vec)it.getSecond());
            }
            collection = (List)destination$iv$iv3;
            String string = "Declared " + n + " cols but row(s) " + collection2 + " contain(s) " + (List)collection + " inputs, respectively";
            throw new IllegalArgumentException(string.toString());
        }
        return list;
    }

    @NotNull
    public final List<SFun<X>> getFlattened() {
        Lazy lazy = this.flattened$delegate;
        return (List)lazy.getValue();
    }

    public final int getNumRows() {
        return this.numRows;
    }

    public final int getNumCols() {
        Lazy lazy = this.numCols$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @NotNull
    public final List<Integer> getIndices() {
        return this.indices;
    }

    @NotNull
    public final List<VFun<X, R>> getCols() {
        Lazy lazy = this.cols$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public VFun<X, C> sum() {
        Iterable $this$reduce$iv = this.getRows();
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void it;
            VFun vFun = (VFun)iterator$iv.next();
            VFun acc = (VFun)accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.plus(it);
        }
        return (VFun)accumulator$iv;
    }

    @Override
    @NotNull
    public Mat<X, C, R> get\u1d40() {
        Lazy lazy = this.\u1d40$delegate;
        return (Mat)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Mat<X, R, C> map(@NotNull Function1<? super SFun<X>, ? extends SFun<X>> ef) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(ef, (String)"ef");
        Iterable $this$map$iv = this.getRows();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void row;
            VFun vFun = (VFun)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(row.map((Function1)new Function1<SFun<X>, SFun<X>>(ef, this){
                final /* synthetic */ Function1<SFun<X>, SFun<X>> $ef;
                final /* synthetic */ Mat<X, R, C> this$0;
                {
                    this.$ef = $ef;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final SFun<X> invoke(@NotNull SFun<X> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    Pair[] pairArray = new Pair[]{TuplesKt.to(this.this$0.getMapInput(), it)};
                    return ((SFun)this.$ef.invoke(it)).invoke(pairArray);
                }
            }));
        }
        List list = (List)destination$iv$iv;
        return new Mat<X, R, C>(list);
    }

    @Override
    @NotNull
    public Mat<X, R, C> unaryMinus() {
        return this.map(unaryMinus.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MFun<X, R, C> plus(@NotNull MFun<X, R, C> addend) {
        MFun mFun;
        Intrinsics.checkNotNullParameter(addend, (String)"addend");
        if (addend instanceof Mat) {
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = this.getRows();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i;
                void r;
                int n = index$iv$iv;
                index$iv$iv = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                VFun vFun = (VFun)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(r.plus(((Mat)addend).get((int)i)));
            }
            List list = (List)destination$iv$iv;
            mFun = new Mat<X, R, C>(list);
        } else {
            mFun = super.plus(addend);
        }
        return mFun;
    }

    @NotNull
    public final VFun<X, C> get(int i) {
        return this.getRows().get(i);
    }

    @NotNull
    public final SFun<X> get(int i, int j) {
        return ((Vec)this.getRows().get(i)).get(j);
    }

    @Override
    @NotNull
    public Mat<X, R, C> times(@NotNull SFun<X> multiplicand) {
        Intrinsics.checkNotNullParameter(multiplicand, (String)"multiplicand");
        return this.map(new Function1<SFun<X>, SFun<X>>(multiplicand){
            final /* synthetic */ SFun<X> $multiplicand;
            {
                this.$multiplicand = $multiplicand;
                super(1);
            }

            @NotNull
            public final SFun<X> invoke(@NotNull SFun<X> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.times(this.$multiplicand);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public VFun<X, R> times(@NotNull VFun<X, C> multiplicand) {
        VFun vFun;
        Intrinsics.checkNotNullParameter(multiplicand, (String)"multiplicand");
        if (multiplicand instanceof Vec) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.getRows();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void r;
                VFun vFun2 = (VFun)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(r.dot(multiplicand));
            }
            List list = (List)destination$iv$iv;
            vFun = new Vec(list);
        } else {
            vFun = super.times(multiplicand);
        }
        return vFun;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <Q extends D1> MFun<X, R, Q> times(@NotNull MFun<X, C, Q> multiplicand) {
        MFun mFun;
        Intrinsics.checkNotNullParameter(multiplicand, (String)"multiplicand");
        if (multiplicand instanceof Mat) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.indices;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                int n = ((Number)item$iv$iv).intValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Iterable $this$map$iv2 = (Iterable)CollectionsKt.getIndices((Collection)((Mat)multiplicand).getCols());
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                Iterator iterator = $this$mapTo$iv$iv2.iterator();
                while (iterator.hasNext()) {
                    void j;
                    void i;
                    int item$iv$iv2;
                    int n2 = item$iv$iv2 = ((IntIterator)iterator).nextInt();
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    collection2.add(this.getRows().get((int)i).dot(((Mat)multiplicand).getCols().get((int)j)));
                }
                List list = (List)destination$iv$iv2;
                collection.add(new Vec(list));
            }
            List list = (List)destination$iv$iv;
            mFun = new Mat<X, R, C>(list);
        } else {
            mFun = super.times(multiplicand);
        }
        return mFun;
    }
}

