/*
 * Decompiled with CFR 0.152.
 */
package ai.hypergraph.kotlingrad.api;

import ai.hypergraph.kotlingrad.api.Constant;
import ai.hypergraph.kotlingrad.api.Fun;
import ai.hypergraph.kotlingrad.api.MFun;
import ai.hypergraph.kotlingrad.api.Mat;
import ai.hypergraph.kotlingrad.api.SFun;
import ai.hypergraph.kotlingrad.api.VFun;
import ai.hypergraph.kotlingrad.api.Vec;
import ai.hypergraph.kotlingrad.shapes.D1;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0016J\u001d\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0096\u0002J\u001d\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0096\u0004J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016JI\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H!\u0012\u0004\u0012\u0002H\"0 \"\b\b\u0001\u0010!*\u00020#\"\b\b\u0002\u0010\"*\u00020#2\u0018\u0010$\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H!\u0012\u0004\u0012\u0002H\"0 H\u0096\u0002J\u001d\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0096\u0002J3\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H&0%\"\b\b\u0001\u0010&*\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H&0%H\u0096\u0002J\b\u0010'\u001a\u00020(H\u0016J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0096\u0002R\u001b\u0010\u0007\u001a\u00020\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006*"}, d2={"Lai/hypergraph/kotlingrad/api/SConst;", "X", "Lai/hypergraph/kotlingrad/api/SFun;", "Lai/hypergraph/kotlingrad/api/Constant;", "value", "", "(Ljava/lang/Number;)V", "doubleValue", "", "getDoubleValue", "()D", "doubleValue$delegate", "Lkotlin/Lazy;", "getValue", "()Ljava/lang/Number;", "cos", "equals", "", "other", "", "hashCode", "", "log", "base", "plus", "addend", "pow", "exponent", "sin", "sqrt", "tan", "times", "Lai/hypergraph/kotlingrad/api/MFun;", "R", "C", "Lai/hypergraph/kotlingrad/shapes/D1;", "multiplicand", "Lai/hypergraph/kotlingrad/api/VFun;", "E", "toString", "", "unaryMinus", "kotlingrad"})
public class SConst<X extends SFun<X>>
extends SFun<X>
implements Constant<X> {
    @NotNull
    private final Number value;
    @NotNull
    private final Lazy doubleValue$delegate;

    public SConst(@NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        super(new Fun[0], (DefaultConstructorMarker)null);
        this.value = value;
        this.doubleValue$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Double>(this){
            final /* synthetic */ SConst<X> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Double invoke() {
                return this.this$0.getValue().doubleValue();
            }
        }));
    }

    @NotNull
    public Number getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getValue().toString();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof SConst ? Intrinsics.areEqual((Object)this.getValue(), (Object)((SConst)other).getValue()) : super.equals(other);
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public double getDoubleValue() {
        Lazy lazy = this.doubleValue$delegate;
        return ((Number)lazy.getValue()).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <E extends D1> VFun<X, E> times(@NotNull VFun<X, E> multiplicand) {
        VFun vFun;
        Intrinsics.checkNotNullParameter(multiplicand, (String)"multiplicand");
        if (multiplicand instanceof Vec) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((Vec)multiplicand).getContents();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SFun sFun = (SFun)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.times((SFun<X>)it));
            }
            List list = (List)destination$iv$iv;
            vFun = new Vec(list);
        } else {
            vFun = super.times(multiplicand);
        }
        return vFun;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <R extends D1, C extends D1> MFun<X, R, C> times(@NotNull MFun<X, R, C> multiplicand) {
        MFun mFun;
        Intrinsics.checkNotNullParameter(multiplicand, (String)"multiplicand");
        if (multiplicand instanceof Mat) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((Mat)multiplicand).getRows();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VFun vFun = (VFun)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.times((VFun)it));
            }
            List list = (List)destination$iv$iv;
            mFun = new Mat(list);
        } else {
            mFun = super.times(multiplicand);
        }
        return mFun;
    }

    @Override
    @NotNull
    public SConst<X> sin() {
        return this.wrap(Math.sin(this.getDoubleValue()));
    }

    @Override
    @NotNull
    public SConst<X> cos() {
        return this.wrap(Math.cos(this.getDoubleValue()));
    }

    @Override
    @NotNull
    public SConst<X> tan() {
        return this.wrap(Math.tan(this.getDoubleValue()));
    }

    @Override
    @NotNull
    public SConst<X> sqrt() {
        return this.wrap(Math.sqrt(this.getDoubleValue()));
    }

    @Override
    @NotNull
    public SConst<X> unaryMinus() {
        return this.wrap(-this.getDoubleValue());
    }

    @Override
    @NotNull
    public SFun<X> log(@NotNull SFun<X> base) {
        Intrinsics.checkNotNullParameter(base, (String)"base");
        return base instanceof SConst ? (SFun)this.wrap(MathKt.log((double)this.getDoubleValue(), (double)((SConst)base).getDoubleValue())) : super.log(base);
    }

    @Override
    @NotNull
    public SFun<X> plus(@NotNull SFun<X> addend) {
        Intrinsics.checkNotNullParameter(addend, (String)"addend");
        return addend instanceof SConst ? (SFun)this.wrap(this.getDoubleValue() + ((SConst)addend).getDoubleValue()) : super.plus(addend);
    }

    @Override
    @NotNull
    public SFun<X> times(@NotNull SFun<X> multiplicand) {
        Intrinsics.checkNotNullParameter(multiplicand, (String)"multiplicand");
        return multiplicand instanceof SConst ? (SFun)this.wrap(this.getDoubleValue() * ((SConst)multiplicand).getDoubleValue()) : super.times(multiplicand);
    }

    @Override
    @NotNull
    public SFun<X> pow(@NotNull SFun<X> exponent) {
        Intrinsics.checkNotNullParameter(exponent, (String)"exponent");
        return exponent instanceof SConst ? (SFun)this.wrap(Math.pow(this.getDoubleValue(), ((SConst)exponent).getDoubleValue())) : super.pow(exponent);
    }
}

