/*******************************************************************************
 * Copyright 2018 Mountain Fog, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License.  You may obtain a copy
 * of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations under
 * the License.
 ******************************************************************************/
package ai.idylnlp.model.entity;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections4.CollectionUtils;

public class EntityMetadata {

  private String name;
  private String value;

  /**
   * Converts a list of {@link EntityMetadata} to a map.
   * @param metadata A list of {@link EntityMetadata}.
   * @return A map that contains the entity metadata.
   */
  public static Map<String, String> toMap(List<EntityMetadata> metadata) {

    Map<String, String> map = new LinkedHashMap<String, String>();

    if(CollectionUtils.isNotEmpty(metadata)) {

      for(EntityMetadata m : metadata) {

        map.put(m.getName(), m.getValue());

      }

    }

    return map;

  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

}