/*
 * Decompiled with CFR 0.152.
 */
package ai.idylnlp.models;

import ai.idylnlp.model.nlp.annotation.AnnotationTypes;
import ai.idylnlp.model.nlp.subjects.BratSubjectOfTrainingOrEvaluation;
import ai.idylnlp.model.nlp.subjects.CoNLL2003SubjectOfTrainingOrEvaluation;
import ai.idylnlp.model.nlp.subjects.IdylNLPSubjectOfTrainingOrEvaluation;
import ai.idylnlp.model.nlp.subjects.OpenNLPSubjectOfTrainingOrEvaluation;
import ai.idylnlp.model.nlp.subjects.SubjectOfTrainingOrEvaluation;
import ai.idylnlp.training.definition.model.TrainingDefinitionReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModelOperationsUtils {
    private static final Logger LOGGER = LogManager.getLogger(ModelOperationsUtils.class);

    public static SubjectOfTrainingOrEvaluation getSubjectOfTrainingOrEvaluation(TrainingDefinitionReader reader) {
        String inputFile = reader.getTrainingDefinition().getTrainingdata().getFile();
        IdylNLPSubjectOfTrainingOrEvaluation subjectOfTraining = null;
        if (reader.getTrainingDefinition().getTrainingdata().getFormat().equalsIgnoreCase(AnnotationTypes.IDYLNLP.getName())) {
            LOGGER.debug("Using Idyl NLP data format.");
            subjectOfTraining = new IdylNLPSubjectOfTrainingOrEvaluation(inputFile, reader.getTrainingDefinition().getTrainingdata().getAnnotations());
        } else if (reader.getTrainingDefinition().getTrainingdata().getFormat().equalsIgnoreCase(AnnotationTypes.CONLL2003.getName())) {
            LOGGER.debug("Using CoNLL2003 data format.");
            subjectOfTraining = new CoNLL2003SubjectOfTrainingOrEvaluation(inputFile);
        } else if (reader.getTrainingDefinition().getTrainingdata().getFormat().equalsIgnoreCase(AnnotationTypes.BRAT.getName())) {
            LOGGER.debug("Using Brat data format.");
            subjectOfTraining = new BratSubjectOfTrainingOrEvaluation(inputFile);
        } else {
            LOGGER.debug("Using OpenNLP data format.");
            subjectOfTraining = new OpenNLPSubjectOfTrainingOrEvaluation(inputFile);
        }
        return subjectOfTraining;
    }
}

