/*
 * Decompiled with CFR 0.152.
 */
package ai.idylnlp.models.opennlp.training;

import ai.idylnlp.model.nlp.subjects.SubjectOfTrainingOrEvaluation;
import ai.idylnlp.model.training.AccuracyEvaluationResult;
import ai.idylnlp.models.ModelOperationsUtils;
import ai.idylnlp.models.opennlp.training.model.ModelSeparateDataValidationOperations;
import ai.idylnlp.models.opennlp.training.model.ModelTrainingOperations;
import ai.idylnlp.models.opennlp.training.model.TrainingAlgorithm;
import ai.idylnlp.opennlp.custom.encryption.OpenNLPEncryptionFactory;
import ai.idylnlp.training.definition.model.TrainingDefinitionReader;
import com.neovisionaries.i18n.LanguageCode;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import opennlp.tools.cmdline.lemmatizer.LemmatizerFineGrainedReportListener;
import opennlp.tools.lemmatizer.LemmaSampleStream;
import opennlp.tools.lemmatizer.Lemmatizer;
import opennlp.tools.lemmatizer.LemmatizerEvaluationMonitor;
import opennlp.tools.lemmatizer.LemmatizerEvaluator;
import opennlp.tools.lemmatizer.LemmatizerFactory;
import opennlp.tools.lemmatizer.LemmatizerME;
import opennlp.tools.lemmatizer.LemmatizerModel;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.MarkableFileInputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.TrainingParameters;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LemmatizerModelOperations
implements ModelTrainingOperations,
ModelSeparateDataValidationOperations<AccuracyEvaluationResult> {
    private static final Logger LOGGER = LogManager.getLogger(LemmatizerModelOperations.class);

    public static String train(TrainingDefinitionReader reader) throws IOException {
        LemmatizerModelOperations ops = new LemmatizerModelOperations();
        SubjectOfTrainingOrEvaluation subjectOfTraining = ModelOperationsUtils.getSubjectOfTrainingOrEvaluation(reader);
        String modelFile = reader.getTrainingDefinition().getModel().getFile();
        String language = reader.getTrainingDefinition().getModel().getLanguage();
        String encryptionKey = reader.getTrainingDefinition().getModel().getEncryptionkey();
        int cutOff = reader.getTrainingDefinition().getAlgorithm().getCutoff().intValue();
        int iterations = reader.getTrainingDefinition().getAlgorithm().getIterations().intValue();
        int threads = reader.getTrainingDefinition().getAlgorithm().getThreads().intValue();
        String algorithm = reader.getTrainingDefinition().getAlgorithm().getName();
        LanguageCode languageCode = LanguageCode.getByCodeIgnoreCase((String)language);
        if (algorithm.equalsIgnoreCase(TrainingAlgorithm.PERCEPTRON.getName())) {
            return ops.trainPerceptron(subjectOfTraining, modelFile, languageCode, encryptionKey, cutOff, iterations);
        }
        if (algorithm.equalsIgnoreCase(TrainingAlgorithm.MAXENT_QN.getName())) {
            double l1 = reader.getTrainingDefinition().getAlgorithm().getL1().doubleValue();
            double l2 = reader.getTrainingDefinition().getAlgorithm().getL2().doubleValue();
            int m = reader.getTrainingDefinition().getAlgorithm().getM().intValue();
            int max = reader.getTrainingDefinition().getAlgorithm().getMax().intValue();
            return ops.trainMaxEntQN(subjectOfTraining, modelFile, languageCode, encryptionKey, cutOff, iterations, threads, l1, l2, m, max);
        }
        throw new IOException("Invalid algorithm specified in the training definition file: " + algorithm);
    }

    @Override
    public AccuracyEvaluationResult separateDataEvaluate(SubjectOfTrainingOrEvaluation SubjectOfTrainingOrEvaluation2, String modelFileName, String encryptionKey) throws IOException {
        LOGGER.info("Doing model evaluation using separate training data.");
        OpenNLPEncryptionFactory.getDefault().setKey(encryptionKey);
        MarkableFileInputStreamFactory inputStreamFactory = new MarkableFileInputStreamFactory(new File(SubjectOfTrainingOrEvaluation2.getInputFile()));
        LemmaSampleStream sample = new LemmaSampleStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)inputStreamFactory, "UTF-8"));
        LemmatizerModel model = new LemmatizerModel(new File(SubjectOfTrainingOrEvaluation2.getInputFile()));
        LemmatizerME posTaggerME = new LemmatizerME(model);
        LemmatizerFineGrainedReportListener monitor = new LemmatizerFineGrainedReportListener();
        LemmatizerEvaluator evaluator = new LemmatizerEvaluator((Lemmatizer)posTaggerME, new LemmatizerEvaluationMonitor[]{monitor});
        evaluator.evaluate((ObjectStream)sample);
        OpenNLPEncryptionFactory.getDefault().clearKey();
        return new AccuracyEvaluationResult(evaluator.getWordAccuracy(), evaluator.getWordCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String trainMaxEntQN(SubjectOfTrainingOrEvaluation SubjectOfTrainingOrEvaluation2, String modelFile, LanguageCode language, String encryptionKey, int cutOff, int iterations, int threads, double l1, double l2, int m, int max) throws IOException {
        LOGGER.info("Beginning tokenizer model training. Output model will be: " + modelFile);
        MarkableFileInputStreamFactory inputStreamFactory = new MarkableFileInputStreamFactory(new File(SubjectOfTrainingOrEvaluation2.getInputFile()));
        PlainTextByLineStream lineStream = new PlainTextByLineStream((InputStreamFactory)inputStreamFactory, "UTF-8");
        LemmaSampleStream sampleStream = new LemmaSampleStream((ObjectStream)lineStream);
        TrainingParameters trainParams = new TrainingParameters();
        trainParams.put("Cutoff", Integer.toString(cutOff));
        trainParams.put("Iterations", Integer.toString(iterations));
        trainParams.put("Algorithm", TrainingAlgorithm.MAXENT_QN.getAlgorithm());
        trainParams.put("Threads", Integer.toString(threads));
        trainParams.put("L1Cost", String.valueOf(l1));
        trainParams.put("L2Cost", String.valueOf(l2));
        trainParams.put("NumOfUpdates", String.valueOf(m));
        trainParams.put("MaxFctEval", String.valueOf(max));
        LemmatizerFactory lemmatizerFactory = new LemmatizerFactory();
        OpenNLPEncryptionFactory.getDefault().setKey(encryptionKey);
        LemmatizerModel model = LemmatizerME.train((String)language.getAlpha3().toString(), (ObjectStream)sampleStream, (TrainingParameters)trainParams, (LemmatizerFactory)lemmatizerFactory);
        FilterOutputStream modelOut = null;
        String modelId = "";
        try {
            modelOut = new BufferedOutputStream(new FileOutputStream(modelFile));
            modelId = model.serialize((OutputStream)modelOut);
        }
        finally {
            if (modelOut != null) {
                modelOut.close();
            }
            lineStream.close();
            OpenNLPEncryptionFactory.getDefault().clearKey();
        }
        return modelId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String trainPerceptron(SubjectOfTrainingOrEvaluation SubjectOfTrainingOrEvaluation2, String modelFile, LanguageCode language, String encryptionKey, int cutOff, int iterations) throws IOException {
        LOGGER.info("Beginning tokenizer model training. Output model will be: " + modelFile);
        MarkableFileInputStreamFactory inputStreamFactory = new MarkableFileInputStreamFactory(new File(SubjectOfTrainingOrEvaluation2.getInputFile()));
        PlainTextByLineStream lineStream = new PlainTextByLineStream((InputStreamFactory)inputStreamFactory, "UTF-8");
        LemmaSampleStream sampleStream = new LemmaSampleStream((ObjectStream)lineStream);
        TrainingParameters trainParams = new TrainingParameters();
        trainParams.put("Cutoff", Integer.toString(cutOff));
        trainParams.put("Iterations", Integer.toString(iterations));
        trainParams.put("Algorithm", TrainingAlgorithm.PERCEPTRON.getAlgorithm());
        LemmatizerFactory lemmatizerFactory = new LemmatizerFactory();
        OpenNLPEncryptionFactory.getDefault().setKey(encryptionKey);
        LemmatizerModel model = LemmatizerME.train((String)language.getAlpha3().toString(), (ObjectStream)sampleStream, (TrainingParameters)trainParams, (LemmatizerFactory)lemmatizerFactory);
        FilterOutputStream modelOut = null;
        String modelId = "";
        try {
            modelOut = new BufferedOutputStream(new FileOutputStream(modelFile));
            modelId = model.serialize((OutputStream)modelOut);
        }
        finally {
            if (modelOut != null) {
                modelOut.close();
            }
            lineStream.close();
            OpenNLPEncryptionFactory.getDefault().clearKey();
        }
        return modelId;
    }
}

