/*
 * Decompiled with CFR 0.152.
 */
package ai.idylnlp.models.opennlp.training;

import ai.idylnlp.model.nlp.subjects.SubjectOfTrainingOrEvaluation;
import ai.idylnlp.model.training.FMeasure;
import ai.idylnlp.model.training.FMeasureModelValidationResult;
import ai.idylnlp.models.ModelOperationsUtils;
import ai.idylnlp.models.opennlp.training.model.ModelCrossValidationOperations;
import ai.idylnlp.models.opennlp.training.model.ModelSeparateDataValidationOperations;
import ai.idylnlp.models.opennlp.training.model.ModelTrainingOperations;
import ai.idylnlp.models.opennlp.training.model.TrainingAlgorithm;
import ai.idylnlp.opennlp.custom.encryption.OpenNLPEncryptionFactory;
import ai.idylnlp.training.definition.model.TrainingDefinitionReader;
import com.neovisionaries.i18n.LanguageCode;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import opennlp.tools.cmdline.tokenizer.TokenEvaluationErrorListener;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.tokenize.TokenSampleStream;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.TokenizerCrossValidator;
import opennlp.tools.tokenize.TokenizerEvaluationMonitor;
import opennlp.tools.tokenize.TokenizerEvaluator;
import opennlp.tools.tokenize.TokenizerFactory;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.MarkableFileInputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.TrainingParameters;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TokenModelOperations
implements ModelTrainingOperations,
ModelSeparateDataValidationOperations<FMeasureModelValidationResult>,
ModelCrossValidationOperations<FMeasureModelValidationResult> {
    private static final Logger LOGGER = LogManager.getLogger(TokenModelOperations.class);

    public static String train(TrainingDefinitionReader reader) throws IOException {
        TokenModelOperations ops = new TokenModelOperations();
        SubjectOfTrainingOrEvaluation subjectOfTraining = ModelOperationsUtils.getSubjectOfTrainingOrEvaluation(reader);
        String modelFile = reader.getTrainingDefinition().getModel().getFile();
        String language = reader.getTrainingDefinition().getModel().getLanguage();
        String encryptionKey = reader.getTrainingDefinition().getModel().getEncryptionkey();
        int cutOff = reader.getTrainingDefinition().getAlgorithm().getCutoff().intValue();
        int iterations = reader.getTrainingDefinition().getAlgorithm().getIterations().intValue();
        int threads = reader.getTrainingDefinition().getAlgorithm().getThreads().intValue();
        String algorithm = reader.getTrainingDefinition().getAlgorithm().getName();
        LanguageCode languageCode = LanguageCode.getByCodeIgnoreCase((String)language);
        if (algorithm.equalsIgnoreCase(TrainingAlgorithm.PERCEPTRON.getName())) {
            return ops.trainPerceptron(subjectOfTraining, modelFile, languageCode, encryptionKey, cutOff, iterations);
        }
        if (algorithm.equalsIgnoreCase(TrainingAlgorithm.MAXENT_QN.getName())) {
            double l1 = reader.getTrainingDefinition().getAlgorithm().getL1().doubleValue();
            double l2 = reader.getTrainingDefinition().getAlgorithm().getL2().doubleValue();
            int m = reader.getTrainingDefinition().getAlgorithm().getM().intValue();
            int max = reader.getTrainingDefinition().getAlgorithm().getMax().intValue();
            return ops.trainMaxEntQN(subjectOfTraining, modelFile, languageCode, encryptionKey, cutOff, iterations, threads, l1, l2, m, max);
        }
        throw new IOException("Invalid algorithm specified in the training definition file: " + algorithm);
    }

    public static FMeasureModelValidationResult crossValidate(TrainingDefinitionReader reader, int folds) throws IOException {
        String language = reader.getTrainingDefinition().getModel().getLanguage();
        int iterations = reader.getTrainingDefinition().getAlgorithm().getIterations().intValue();
        int cutoff = reader.getTrainingDefinition().getAlgorithm().getCutoff().intValue();
        String algorithm = reader.getTrainingDefinition().getAlgorithm().getName();
        double l1 = reader.getTrainingDefinition().getAlgorithm().getL1().doubleValue();
        double l2 = reader.getTrainingDefinition().getAlgorithm().getL2().doubleValue();
        int m = reader.getTrainingDefinition().getAlgorithm().getM().intValue();
        int max = reader.getTrainingDefinition().getAlgorithm().getMax().intValue();
        LanguageCode languageCode = LanguageCode.getByCodeIgnoreCase((String)language);
        SubjectOfTrainingOrEvaluation subjectOfTraining = ModelOperationsUtils.getSubjectOfTrainingOrEvaluation(reader);
        TokenModelOperations tokenModelOperations = new TokenModelOperations();
        FMeasureModelValidationResult result = null;
        if (StringUtils.equalsIgnoreCase((String)algorithm, (String)TrainingAlgorithm.PERCEPTRON.getName())) {
            result = tokenModelOperations.crossValidationEvaluatePerceptron(subjectOfTraining, languageCode, iterations, cutoff, folds);
        } else if (StringUtils.equalsIgnoreCase((String)algorithm, (String)TrainingAlgorithm.MAXENT_QN.getName())) {
            result = tokenModelOperations.crossValidationEvaluateMaxEntQN(subjectOfTraining, languageCode, iterations, cutoff, folds, l1, l2, m, max);
        } else {
            throw new IOException("Invalid algorithm specified in the training definition file: " + algorithm);
        }
        return result;
    }

    @Override
    public FMeasureModelValidationResult crossValidationEvaluateMaxEntQN(SubjectOfTrainingOrEvaluation subjectOfTraining, LanguageCode language, int iterations, int cutOff, int folds, double l1, double l2, int m, int max) throws IOException {
        LOGGER.info("Doing model evaluation using cross-validation with {} folds.", (Object)folds);
        MarkableFileInputStreamFactory inputStreamFactory = new MarkableFileInputStreamFactory(new File(subjectOfTraining.getInputFile()));
        TokenSampleStream sample = new TokenSampleStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)inputStreamFactory, "UTF-8"));
        TrainingParameters trainParams = new TrainingParameters();
        trainParams.put("Cutoff", Integer.toString(cutOff));
        trainParams.put("Iterations", Integer.toString(iterations));
        trainParams.put("Algorithm", TrainingAlgorithm.MAXENT_QN.getAlgorithm());
        trainParams.put("L1Cost", String.valueOf(l1));
        trainParams.put("L2Cost", String.valueOf(l2));
        trainParams.put("NumOfUpdates", String.valueOf(m));
        trainParams.put("MaxFctEval", String.valueOf(max));
        TokenizerFactory factory = new TokenizerFactory(language.getAlpha3().toString(), null, false, null);
        TokenEvaluationErrorListener monitor = new TokenEvaluationErrorListener();
        TokenizerCrossValidator evaluator = new TokenizerCrossValidator(trainParams, factory, new TokenizerEvaluationMonitor[]{monitor});
        evaluator.evaluate((ObjectStream)sample, folds);
        FMeasure fmeasure = new FMeasure(evaluator.getFMeasure().getPrecisionScore(), evaluator.getFMeasure().getRecallScore(), evaluator.getFMeasure().getFMeasure());
        return new FMeasureModelValidationResult(fmeasure);
    }

    @Override
    public FMeasureModelValidationResult crossValidationEvaluatePerceptron(SubjectOfTrainingOrEvaluation subjectOfTraining, LanguageCode language, int iterations, int cutOff, int folds) throws IOException {
        LOGGER.info("Doing model evaluation using cross-validation with {} folds.", (Object)folds);
        MarkableFileInputStreamFactory inputStreamFactory = new MarkableFileInputStreamFactory(new File(subjectOfTraining.getInputFile()));
        TokenSampleStream sample = new TokenSampleStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)inputStreamFactory, "UTF-8"));
        TrainingParameters trainParams = new TrainingParameters();
        trainParams.put("Cutoff", Integer.toString(cutOff));
        trainParams.put("Iterations", Integer.toString(iterations));
        trainParams.put("Algorithm", TrainingAlgorithm.PERCEPTRON.getAlgorithm());
        TokenizerFactory factory = new TokenizerFactory(language.getAlpha3().toString(), null, false, null);
        TokenEvaluationErrorListener monitor = new TokenEvaluationErrorListener();
        TokenizerCrossValidator evaluator = new TokenizerCrossValidator(trainParams, factory, new TokenizerEvaluationMonitor[]{monitor});
        evaluator.evaluate((ObjectStream)sample, folds);
        FMeasure fmeasure = new FMeasure(evaluator.getFMeasure().getPrecisionScore(), evaluator.getFMeasure().getRecallScore(), evaluator.getFMeasure().getFMeasure());
        return new FMeasureModelValidationResult(fmeasure);
    }

    @Override
    public FMeasureModelValidationResult separateDataEvaluate(SubjectOfTrainingOrEvaluation subjectOfTraining, String modelFileName, String encryptionKey) throws IOException {
        LOGGER.info("Doing model evaluation using separate training data.");
        OpenNLPEncryptionFactory.getDefault().setKey(encryptionKey);
        MarkableFileInputStreamFactory inputStreamFactory = new MarkableFileInputStreamFactory(new File(subjectOfTraining.getInputFile()));
        TokenSampleStream sample = new TokenSampleStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)inputStreamFactory, "UTF-8"));
        TokenizerModel model = new TokenizerModel(new File(modelFileName));
        TokenizerME nameFinderME = new TokenizerME(model);
        TokenizerEvaluator evaluator = new TokenizerEvaluator((Tokenizer)nameFinderME, new TokenizerEvaluationMonitor[0]);
        evaluator.evaluate((ObjectStream)sample);
        OpenNLPEncryptionFactory.getDefault().clearKey();
        FMeasure fmeasure = new FMeasure(evaluator.getFMeasure().getPrecisionScore(), evaluator.getFMeasure().getRecallScore(), evaluator.getFMeasure().getFMeasure());
        return new FMeasureModelValidationResult(fmeasure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String trainMaxEntQN(SubjectOfTrainingOrEvaluation subjectOfTraining, String modelFile, LanguageCode language, String encryptionKey, int cutOff, int iterations, int threads, double l1, double l2, int m, int max) throws IOException {
        LOGGER.info("Beginning tokenizer model training. Output model will be: " + modelFile);
        MarkableFileInputStreamFactory inputStreamFactory = new MarkableFileInputStreamFactory(new File(subjectOfTraining.getInputFile()));
        PlainTextByLineStream lineStream = new PlainTextByLineStream((InputStreamFactory)inputStreamFactory, "UTF-8");
        TokenSampleStream sampleStream = new TokenSampleStream((ObjectStream)lineStream);
        TrainingParameters trainParams = new TrainingParameters();
        trainParams.put("Cutoff", Integer.toString(cutOff));
        trainParams.put("Iterations", Integer.toString(iterations));
        trainParams.put("Algorithm", TrainingAlgorithm.MAXENT_QN.getAlgorithm());
        trainParams.put("Threads", Integer.toString(threads));
        trainParams.put("L1Cost", String.valueOf(l1));
        trainParams.put("L2Cost", String.valueOf(l2));
        trainParams.put("NumOfUpdates", String.valueOf(m));
        trainParams.put("MaxFctEval", String.valueOf(max));
        TokenizerFactory tokenizerFactory = new TokenizerFactory(language.getAlpha3().toString(), new Dictionary(), false, null);
        OpenNLPEncryptionFactory.getDefault().setKey(encryptionKey);
        TokenizerModel model = TokenizerME.train((ObjectStream)sampleStream, (TokenizerFactory)tokenizerFactory, (TrainingParameters)trainParams);
        FilterOutputStream modelOut = null;
        String modelId = "";
        try {
            modelOut = new BufferedOutputStream(new FileOutputStream(modelFile));
            modelId = model.serialize((OutputStream)modelOut);
        }
        finally {
            if (modelOut != null) {
                modelOut.close();
            }
            lineStream.close();
            OpenNLPEncryptionFactory.getDefault().clearKey();
        }
        return modelId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String trainPerceptron(SubjectOfTrainingOrEvaluation subjectOfTraining, String modelFile, LanguageCode language, String encryptionKey, int cutOff, int iterations) throws IOException {
        LOGGER.info("Beginning tokenizer model training. Output model will be: " + modelFile);
        MarkableFileInputStreamFactory inputStreamFactory = new MarkableFileInputStreamFactory(new File(subjectOfTraining.getInputFile()));
        PlainTextByLineStream lineStream = new PlainTextByLineStream((InputStreamFactory)inputStreamFactory, "UTF-8");
        TokenSampleStream sampleStream = new TokenSampleStream((ObjectStream)lineStream);
        TrainingParameters trainParams = new TrainingParameters();
        trainParams.put("Cutoff", Integer.toString(cutOff));
        trainParams.put("Iterations", Integer.toString(iterations));
        trainParams.put("Algorithm", TrainingAlgorithm.PERCEPTRON.getAlgorithm());
        TokenizerFactory tokenizerFactory = new TokenizerFactory(language.getAlpha3().toString(), new Dictionary(), false, null);
        OpenNLPEncryptionFactory.getDefault().setKey(encryptionKey);
        TokenizerModel model = TokenizerME.train((ObjectStream)sampleStream, (TokenizerFactory)tokenizerFactory, (TrainingParameters)trainParams);
        FilterOutputStream modelOut = null;
        String modelId = "";
        try {
            modelOut = new BufferedOutputStream(new FileOutputStream(modelFile));
            modelId = model.serialize((OutputStream)modelOut);
        }
        finally {
            if (modelOut != null) {
                modelOut.close();
            }
            lineStream.close();
            OpenNLPEncryptionFactory.getDefault().clearKey();
        }
        return modelId;
    }
}

