/*
 * Decompiled with CFR 0.152.
 */
package ai.idylnlp.models.opennlp.training.model;

public enum TrainingAlgorithm {
    MAXENT_QN("MAXENT_QN", "maxent-qn"),
    PERCEPTRON("PERCEPTRON", "perceptron");

    private String algorithm;
    private String name;

    private TrainingAlgorithm(String algorithm, String name) {
        this.algorithm = algorithm;
        this.name = name;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getName() {
        return this.name;
    }

    public static TrainingAlgorithm getDefaultAlgorithm() {
        return PERCEPTRON;
    }

    public String toString() {
        return this.algorithm;
    }

    public static TrainingAlgorithm fromValue(String algorithm) {
        if (algorithm.equalsIgnoreCase(MAXENT_QN.getName())) {
            return MAXENT_QN;
        }
        if (algorithm.equalsIgnoreCase(PERCEPTRON.getName())) {
            return PERCEPTRON;
        }
        throw new IllegalArgumentException("Invalid algorithm.");
    }
}

