/*
 * Decompiled with CFR 0.152.
 */
package ai.idylnlp.nlp.documents.opennlp;

import ai.idylnlp.model.nlp.documents.DocumentClassificationEvaluationRequest;
import ai.idylnlp.model.nlp.documents.DocumentClassificationEvaluationResponse;
import ai.idylnlp.model.nlp.documents.DocumentClassificationResponse;
import ai.idylnlp.model.nlp.documents.DocumentClassificationScores;
import ai.idylnlp.model.nlp.documents.DocumentClassifier;
import ai.idylnlp.model.nlp.documents.DocumentClassifierException;
import ai.idylnlp.model.nlp.documents.OpenNLPDocumentClassificationRequest;
import ai.idylnlp.nlp.documents.opennlp.model.OpenNLPDocumentClassifierConfiguration;
import com.neovisionaries.i18n.LanguageCode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.doccat.DoccatModel;
import opennlp.tools.doccat.DocumentCategorizerME;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OpenNLPDocumentClassifier
implements DocumentClassifier<OpenNLPDocumentClassifierConfiguration, OpenNLPDocumentClassificationRequest> {
    private static final Logger LOGGER = LogManager.getLogger(OpenNLPDocumentClassifier.class);
    private OpenNLPDocumentClassifierConfiguration configuration;
    private Map<LanguageCode, DocumentCategorizerME> doccatModelCache;

    public OpenNLPDocumentClassifier(OpenNLPDocumentClassifierConfiguration configuration) throws DocumentClassifierException {
        this.configuration = configuration;
        this.doccatModelCache = new HashMap<LanguageCode, DocumentCategorizerME>();
        if (configuration.isPreloadModels()) {
            LOGGER.info("Preloading the document classification models.");
            for (LanguageCode languageCode : configuration.getDoccatModels().keySet()) {
                try {
                    this.getDocumentCategorizer(languageCode);
                }
                catch (FileNotFoundException ex) {
                    String fileName = configuration.getDoccatModels().get(languageCode).getAbsolutePath();
                    LOGGER.error("The model file {} was not found.", (Object)ex, (Object)fileName);
                }
            }
        }
    }

    public DocumentClassificationResponse classify(OpenNLPDocumentClassificationRequest request) throws DocumentClassifierException {
        try {
            DocumentCategorizerME categorizer = this.getDocumentCategorizer(request.getLanguageCode());
            String[] tokens = WhitespaceTokenizer.INSTANCE.tokenize(request.getText());
            double[] outcomes = categorizer.categorize(tokens);
            HashMap<String, Double> scores = new HashMap<String, Double>();
            for (int i = 0; i < outcomes.length; ++i) {
                scores.put(categorizer.getCategory(i), outcomes[i]);
            }
            return new DocumentClassificationResponse(new DocumentClassificationScores(scores));
        }
        catch (Exception ex) {
            throw new DocumentClassifierException("Unable to classify document.", ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DocumentCategorizerME getDocumentCategorizer(LanguageCode languageCode) throws DocumentClassifierException, FileNotFoundException {
        LOGGER.info("Loading document classification model for language {}.", (Object)languageCode.getAlpha3().toString());
        DocumentCategorizerME documentCategorizer = this.doccatModelCache.get(languageCode);
        if (documentCategorizer != null) return documentCategorizer;
        File file = this.configuration.getDoccatModels().get(languageCode);
        if (file == null) throw new DocumentClassifierException("No model file for language " + languageCode.getAlpha3().toString() + ".");
        if (!file.exists()) throw new DocumentClassifierException("The model file for language " + languageCode.getAlpha3().toString() + " does not exist.");
        FileInputStream is = new FileInputStream(file);
        try {
            DoccatModel doccatModel = new DoccatModel((InputStream)is);
            documentCategorizer = new DocumentCategorizerME(doccatModel);
            this.doccatModelCache.put(languageCode, documentCategorizer);
            return documentCategorizer;
        }
        catch (IOException ex) {
            LOGGER.error("Unable to perform document classification.", (Throwable)ex);
            throw new DocumentClassifierException("Unable to perform document classification.", (Exception)ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public DocumentClassificationEvaluationResponse evaluate(DocumentClassificationEvaluationRequest request) throws DocumentClassifierException {
        return null;
    }
}

