/*
 * Decompiled with CFR 0.152.
 */
package ai.idylnlp.nlp.documents.opennlp;

import ai.idylnlp.model.nlp.documents.DocumentClassificationFile;
import ai.idylnlp.model.nlp.documents.DocumentClassificationTrainingResponse;
import ai.idylnlp.model.nlp.documents.DocumentClassifierModelOperations;
import ai.idylnlp.model.nlp.documents.DocumentModelTrainingException;
import ai.idylnlp.model.nlp.documents.OpenNLPDocumentClassifierTrainingRequest;
import ai.idylnlp.opennlp.custom.encryption.OpenNLPEncryptionFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import opennlp.tools.doccat.DoccatFactory;
import opennlp.tools.doccat.DoccatModel;
import opennlp.tools.doccat.DocumentCategorizerME;
import opennlp.tools.doccat.DocumentSampleStream;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.MarkableFileInputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.TrainingParameters;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OpenNLPDocumentModelOperations
implements DocumentClassifierModelOperations<OpenNLPDocumentClassifierTrainingRequest> {
    private static final Logger LOGGER = LogManager.getLogger(OpenNLPDocumentModelOperations.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentClassificationTrainingResponse train(OpenNLPDocumentClassifierTrainingRequest request) throws DocumentModelTrainingException {
        try {
            MarkableFileInputStreamFactory inputStreamFactory = new MarkableFileInputStreamFactory(request.getTrainingFile());
            DocumentSampleStream sample = new DocumentSampleStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)inputStreamFactory, "UTF-8"));
            String language = request.getLanguageCode().getAlpha3().toString();
            DoccatModel model = DocumentCategorizerME.train((String)language, (ObjectStream)sample, (TrainingParameters)TrainingParameters.defaultParams(), (DoccatFactory)new DoccatFactory());
            FilterOutputStream modelOut = null;
            OpenNLPEncryptionFactory.getDefault().setKey(request.getEncryptionKey());
            String modelId = "";
            File modelFile = File.createTempFile("model", ".bin");
            try {
                modelOut = new BufferedOutputStream(new FileOutputStream(modelFile));
                modelId = model.serialize((OutputStream)modelOut);
            }
            catch (Exception ex) {
                LOGGER.error("Unable to create the model.", (Throwable)ex);
            }
            finally {
                if (modelOut != null) {
                    modelOut.close();
                }
                OpenNLPEncryptionFactory.getDefault().clearKey();
            }
            HashMap<DocumentClassificationFile, File> files = new HashMap<DocumentClassificationFile, File>();
            files.put(DocumentClassificationFile.MODEL_FILE, modelFile);
            return new DocumentClassificationTrainingResponse(modelId, files, Collections.emptyList());
        }
        catch (IOException ex) {
            throw new DocumentModelTrainingException("Unable to train document classification model.", (Exception)ex);
        }
    }
}

