/*
 * Decompiled with CFR 0.152.
 */
package ai.idylnlp.nlp.documents.opennlp.model;

import ai.idylnlp.model.nlp.documents.AbstractDocumentClassifierConfiguration;
import com.neovisionaries.i18n.LanguageCode;
import java.io.File;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OpenNLPDocumentClassifierConfiguration
extends AbstractDocumentClassifierConfiguration {
    private static final Logger LOGGER = LogManager.getLogger(OpenNLPDocumentClassifierConfiguration.class);
    private Map<LanguageCode, File> doccatModels;
    private boolean preloadModels;

    private OpenNLPDocumentClassifierConfiguration(Map<LanguageCode, File> doccatModels, boolean preloadModels) {
        this.doccatModels = doccatModels;
        this.preloadModels = preloadModels;
    }

    public Map<LanguageCode, File> getDoccatModels() {
        return this.doccatModels;
    }

    public boolean isPreloadModels() {
        return this.preloadModels;
    }

    public static class Builder {
        private Map<LanguageCode, File> doccatModels;
        private boolean preloadModels;

        public Builder withDoccatModels(Map<LanguageCode, File> doccatModels) {
            this.doccatModels = doccatModels;
            return this;
        }

        public Builder withPreloadModels(boolean preloadModels) {
            this.preloadModels = preloadModels;
            return this;
        }

        public OpenNLPDocumentClassifierConfiguration build() {
            return new OpenNLPDocumentClassifierConfiguration(this.doccatModels, this.preloadModels);
        }
    }
}

