/*
 * Decompiled with CFR 0.152.
 */
package ai.idylnlp.pipeline;

import ai.idylnlp.model.exceptions.EntityFinderException;
import ai.idylnlp.model.exceptions.ModelLoaderException;
import ai.idylnlp.model.nlp.DuplicateEntityStrategy;
import ai.idylnlp.model.nlp.EntityComparator;
import ai.idylnlp.model.nlp.EntityExtractionRequest;
import ai.idylnlp.model.nlp.EntityExtractionResponse;
import ai.idylnlp.model.nlp.EntityOrder;
import ai.idylnlp.model.nlp.EntityRecognizer;
import ai.idylnlp.model.nlp.EntitySanitizer;
import ai.idylnlp.model.nlp.pipeline.Pipeline;
import ai.idylnlp.model.stats.StatsReporter;
import ai.idylnlp.pipeline.IdylPipelineUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IdylPipeline
implements Pipeline {
    private static final Logger LOGGER = LogManager.getLogger(IdylPipeline.class);
    private static Map<String, IdylPipeline> namedPipelines = new HashMap<String, IdylPipeline>();
    private String name;
    private List<EntityRecognizer> entityRecognizers;
    private List<EntitySanitizer> entitySanitizers;
    private StatsReporter statsReporter;
    private DuplicateEntityStrategy duplicateEntityStrategy = DuplicateEntityStrategy.USE_HIGHEST_CONFIDENCE;

    private IdylPipeline(String name, List<EntityRecognizer> entityRecognizers, List<EntitySanitizer> entitySanitizers, StatsReporter statsReporter, DuplicateEntityStrategy duplicateEntityStrategy) {
        this.entityRecognizers = entityRecognizers;
        this.entitySanitizers = entitySanitizers;
        this.statsReporter = statsReporter;
        this.duplicateEntityStrategy = duplicateEntityStrategy;
    }

    public IdylPipeline getIdylPipeline(String name) {
        return namedPipelines.get(name);
    }

    public EntityExtractionResponse run(EntityExtractionRequest request) {
        Set<Object> entities = new HashSet();
        boolean successful = true;
        long extractionTime = 0L;
        try {
            for (EntityRecognizer entityRecognizer : this.entityRecognizers) {
                LOGGER.debug("Processing input with entity recognizer {}.", (Object)entityRecognizer.toString());
                EntityExtractionResponse response = entityRecognizer.extractEntities(request);
                entities.addAll(response.getEntities());
                extractionTime += response.getExtractionTime();
            }
            if (this.statsReporter != null) {
                this.statsReporter.increment("extraction.requests", (long)entities.size());
            }
            for (EntitySanitizer sanitizer : this.entitySanitizers) {
                entities = sanitizer.sanitizeEntities(entities);
            }
            DuplicateEntityStrategy entityExtractionRequestDuplicateEntityStrategy = request.getDuplicateEntityStrategy();
            if (entityExtractionRequestDuplicateEntityStrategy != null) {
                this.duplicateEntityStrategy = entityExtractionRequestDuplicateEntityStrategy;
            }
            if (this.duplicateEntityStrategy == DuplicateEntityStrategy.USE_HIGHEST_CONFIDENCE) {
                entities = IdylPipelineUtils.removeDuplicateEntities(entities);
            }
            entities = EntityComparator.sort(entities, (EntityOrder)request.getOrder());
        }
        catch (EntityFinderException | ModelLoaderException ex) {
            LOGGER.error("Unable to process through the Idyl pipeline.", ex);
            entities = null;
            successful = false;
        }
        return new EntityExtractionResponse(entities, extractionTime, successful);
    }

    public String getName() {
        return this.name;
    }

    public List<EntityRecognizer> getEntityRecognizers() {
        return this.entityRecognizers;
    }

    public List<EntitySanitizer> getEntitySanitiziers() {
        return this.entitySanitizers;
    }

    public StatsReporter getStatsReporter() {
        return this.statsReporter;
    }

    public DuplicateEntityStrategy getDuplicateEntityStrategy() {
        return this.duplicateEntityStrategy;
    }

    public static class IdylPipelineBuilder {
        private List<EntityRecognizer> entityRecognizers;
        private List<EntitySanitizer> entitySanitizers;
        private StatsReporter statsReporter;
        private DuplicateEntityStrategy duplicateEntityStrategy;

        public IdylPipelineBuilder setEntityRecognizers(List<EntityRecognizer> entityRecognizers) {
            this.entityRecognizers = entityRecognizers;
            return this;
        }

        public IdylPipelineBuilder setEntitySanitizers(List<EntitySanitizer> entitySanitizers) {
            this.entitySanitizers = entitySanitizers;
            return this;
        }

        public IdylPipelineBuilder setStatsReporter(StatsReporter statsReporter) {
            this.statsReporter = statsReporter;
            return this;
        }

        public IdylPipelineBuilder setDuplicateEntityStrategy(DuplicateEntityStrategy duplicateEntityStrategy) {
            this.duplicateEntityStrategy = duplicateEntityStrategy;
            return this;
        }

        public IdylPipeline build() {
            return this.build("default");
        }

        public IdylPipeline build(String name) {
            if (this.entityRecognizers == null) {
                this.entityRecognizers = new ArrayList<EntityRecognizer>();
            }
            if (this.entitySanitizers == null) {
                this.entitySanitizers = new ArrayList<EntitySanitizer>();
            }
            IdylPipeline pipeline = new IdylPipeline(name, this.entityRecognizers, this.entitySanitizers, this.statsReporter, this.duplicateEntityStrategy);
            namedPipelines.put(name, pipeline);
            return pipeline;
        }
    }
}

