/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.connector.csv;

import ai.knowly.langtorch.connector.ReadOption;

public class CSVReadOption
implements ReadOption {
    private String filePath;
    private String separatorForEachLine;
    private CSVFormat csvFormat;

    public CSVReadOption(String filePath, String separatorForEachLine, CSVFormat csvFormat) {
        if (filePath == null || filePath.trim().isEmpty()) {
            throw new IllegalArgumentException("filePath must be set");
        }
        this.filePath = filePath;
        this.separatorForEachLine = separatorForEachLine;
        this.csvFormat = csvFormat;
    }

    public static CSVReadOptionBuilder builder() {
        return new CSVReadOptionBuilder();
    }

    public CSVReadOptionBuilder toBuilder() {
        return new CSVReadOptionBuilder().setFilePath(this.filePath).setSeparatorForEachLine(this.separatorForEachLine).setCsvFormat(this.csvFormat);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getSeparatorForEachLine() {
        return this.separatorForEachLine;
    }

    public CSVFormat getCsvFormat() {
        return this.csvFormat;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setSeparatorForEachLine(String separatorForEachLine) {
        this.separatorForEachLine = separatorForEachLine;
    }

    public void setCsvFormat(CSVFormat csvFormat) {
        this.csvFormat = csvFormat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CSVReadOption)) {
            return false;
        }
        CSVReadOption other = (CSVReadOption)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$filePath = this.getFilePath();
        String other$filePath = other.getFilePath();
        if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
            return false;
        }
        String this$separatorForEachLine = this.getSeparatorForEachLine();
        String other$separatorForEachLine = other.getSeparatorForEachLine();
        if (this$separatorForEachLine == null ? other$separatorForEachLine != null : !this$separatorForEachLine.equals(other$separatorForEachLine)) {
            return false;
        }
        CSVFormat this$csvFormat = this.getCsvFormat();
        CSVFormat other$csvFormat = other.getCsvFormat();
        return !(this$csvFormat == null ? other$csvFormat != null : !((Object)((Object)this$csvFormat)).equals((Object)other$csvFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CSVReadOption;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
        String $separatorForEachLine = this.getSeparatorForEachLine();
        result = result * 59 + ($separatorForEachLine == null ? 43 : $separatorForEachLine.hashCode());
        CSVFormat $csvFormat = this.getCsvFormat();
        result = result * 59 + ($csvFormat == null ? 43 : ((Object)((Object)$csvFormat)).hashCode());
        return result;
    }

    public String toString() {
        return "CSVReadOption(filePath=" + this.getFilePath() + ", separatorForEachLine=" + this.getSeparatorForEachLine() + ", csvFormat=" + (Object)((Object)this.getCsvFormat()) + ")";
    }

    public static class CSVReadOptionBuilder {
        private String filePath;
        private String separatorForEachLine;
        private CSVFormat csvFormat;

        CSVReadOptionBuilder() {
        }

        public CSVReadOptionBuilder setFilePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public CSVReadOptionBuilder setSeparatorForEachLine(String separatorForEachLine) {
            this.separatorForEachLine = separatorForEachLine;
            return this;
        }

        public CSVReadOptionBuilder setCsvFormat(CSVFormat csvFormat) {
            this.csvFormat = csvFormat;
            return this;
        }

        public CSVReadOption build() {
            return new CSVReadOption(this.filePath, this.separatorForEachLine, this.csvFormat);
        }

        public String toString() {
            return "CSVReadOption.CSVReadOptionBuilder(filePath=" + this.filePath + ", separatorForEachLine=" + this.separatorForEachLine + ", csvFormat=" + (Object)((Object)this.csvFormat) + ")";
        }

        public CSVReadOptionBuilder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public CSVReadOptionBuilder separatorForEachLine(String separatorForEachLine) {
            this.separatorForEachLine = separatorForEachLine;
            return this;
        }

        public CSVReadOptionBuilder csvFormat(CSVFormat csvFormat) {
            this.csvFormat = csvFormat;
            return this;
        }
    }

    static enum CSVFormat {
        CSV,
        EXCEL;

    }
}

