/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.connector.pdf;

import ai.knowly.langtorch.connector.DocumentConnector;
import ai.knowly.langtorch.connector.pdf.PDFReadOption;
import com.google.common.flogger.FluentLogger;
import java.io.File;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;

public class PDFConnector
extends DocumentConnector<PDFReadOption> {
    FluentLogger logger = FluentLogger.forEnclosingClass();

    private PDFConnector() {
    }

    public static PDFConnector create() {
        return new PDFConnector();
    }

    @Override
    public String read(String filePath) throws IOException {
        return this.read(PDFReadOption.builder().setFilePath(filePath).build());
    }

    @Override
    protected String read(PDFReadOption readOption) throws IOException {
        PDDocument document = PDDocument.load((File)new File(readOption.getFilePath()));
        PDFTextStripper pdfStripper = new PDFTextStripper();
        String text = pdfStripper.getText(document);
        document.close();
        return text;
    }
}

