/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.preprocessing.splitter.text.word;

import ai.knowly.langtorch.preprocessing.splitter.text.SplitterOption;

public class WordSplitterOption
extends SplitterOption {
    private final String text;
    private final int maxLengthPerChunk;

    private WordSplitterOption(String text, int maxLengthPerChunk) {
        super(text);
        this.text = text;
        this.maxLengthPerChunk = maxLengthPerChunk;
    }

    public static WordSplitterOption of(String text, int totalLengthOfChunk) {
        return new WordSplitterOption(text, totalLengthOfChunk);
    }

    public static WordSplitterOptionBuilder builder() {
        return new WordSplitterOptionBuilder();
    }

    public WordSplitterOptionBuilder toBuilder() {
        return new WordSplitterOptionBuilder().setText(this.text).setMaxLengthPerChunk(this.maxLengthPerChunk);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WordSplitterOption)) {
            return false;
        }
        WordSplitterOption other = (WordSplitterOption)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getMaxLengthPerChunk() != other.getMaxLengthPerChunk()) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WordSplitterOption;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getMaxLengthPerChunk();
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    public String getText() {
        return this.text;
    }

    public int getMaxLengthPerChunk() {
        return this.maxLengthPerChunk;
    }

    public String toString() {
        return "WordSplitterOption(text=" + this.getText() + ", maxLengthPerChunk=" + this.getMaxLengthPerChunk() + ")";
    }

    public static class WordSplitterOptionBuilder {
        private String text;
        private int maxLengthPerChunk;

        WordSplitterOptionBuilder() {
        }

        public WordSplitterOptionBuilder setText(String text) {
            this.text = text;
            return this;
        }

        public WordSplitterOptionBuilder setMaxLengthPerChunk(int maxLengthPerChunk) {
            this.maxLengthPerChunk = maxLengthPerChunk;
            return this;
        }

        public WordSplitterOption build() {
            return new WordSplitterOption(this.text, this.maxLengthPerChunk);
        }

        public String toString() {
            return "WordSplitterOption.WordSplitterOptionBuilder(text=" + this.text + ", maxLengthPerChunk=" + this.maxLengthPerChunk + ")";
        }
    }
}

