/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.processor.module.openai.chat;

import ai.knowly.langtorch.processor.llm.openai.service.OpenAIService;
import ai.knowly.langtorch.processor.llm.openai.service.schema.dto.completion.chat.ChatCompletionRequest;
import ai.knowly.langtorch.processor.llm.openai.service.schema.dto.completion.chat.ChatCompletionResult;
import ai.knowly.langtorch.processor.module.Processor;
import ai.knowly.langtorch.processor.module.openai.OpenAIServiceProvider;
import ai.knowly.langtorch.processor.module.openai.chat.OpenAIChatProcessorConfig;
import ai.knowly.langtorch.processor.module.openai.chat.OpenAIChatProcessorRequestConverter;
import ai.knowly.langtorch.processor.module.openai.chat.UnknownMessageException;
import ai.knowly.langtorch.schema.chat.AssistantMessage;
import ai.knowly.langtorch.schema.chat.ChatMessage;
import ai.knowly.langtorch.schema.chat.Role;
import ai.knowly.langtorch.schema.chat.SystemMessage;
import ai.knowly.langtorch.schema.chat.UserMessage;
import ai.knowly.langtorch.schema.text.MultiChatMessage;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import javax.inject.Inject;

public class OpenAIChatProcessor
implements Processor<MultiChatMessage, ChatMessage> {
    private static final String DEFAULT_MODEL = "gpt-3.5-turbo";
    private static final int DEFAULT_MAX_TOKEN = 2048;
    private final OpenAIService openAIService;
    private OpenAIChatProcessorConfig openAIChatProcessorConfig = OpenAIChatProcessorConfig.builder().setModel("gpt-3.5-turbo").setMaxTokens(2048).build();

    @Inject
    OpenAIChatProcessor(OpenAIService openAIService) {
        this.openAIService = openAIService;
    }

    private OpenAIChatProcessor() {
        this.openAIService = OpenAIServiceProvider.createOpenAIService();
    }

    public static OpenAIChatProcessor create(String openAIKey) {
        return new OpenAIChatProcessor(OpenAIServiceProvider.createOpenAIService(openAIKey));
    }

    public static OpenAIChatProcessor create() {
        return new OpenAIChatProcessor();
    }

    public static OpenAIChatProcessor create(OpenAIService openAIService) {
        return new OpenAIChatProcessor(openAIService);
    }

    public OpenAIChatProcessor withConfig(OpenAIChatProcessorConfig openAIChatProcessorConfig) {
        this.openAIChatProcessorConfig = openAIChatProcessorConfig;
        return this;
    }

    @Override
    public ChatMessage run(MultiChatMessage inputData) {
        ChatCompletionRequest chatCompletionRequest = OpenAIChatProcessorRequestConverter.convert(this.openAIChatProcessorConfig, inputData.getMessages());
        ChatCompletionResult chatCompletion = this.openAIService.createChatCompletion(chatCompletionRequest);
        ChatMessage chatMessage = chatCompletion.getChoices().get(0).getMessage();
        if (Role.USER == chatMessage.getRole()) {
            return UserMessage.of(chatMessage.getContent());
        }
        if (Role.SYSTEM == chatMessage.getRole()) {
            return SystemMessage.of(chatMessage.getContent());
        }
        if (Role.ASSISTANT == chatMessage.getRole()) {
            return AssistantMessage.of(chatMessage.getContent());
        }
        throw new UnknownMessageException(String.format("Unknown role %s with message: %s ", new Object[]{chatMessage.getRole(), chatMessage.getContent()}));
    }

    @Override
    public ListenableFuture<ChatMessage> runAsync(MultiChatMessage inputData) {
        ChatCompletionRequest chatCompletionRequest = OpenAIChatProcessorRequestConverter.convert(this.openAIChatProcessorConfig, inputData.getMessages());
        ListenableFuture<ChatCompletionResult> chatCompletionAsync = this.openAIService.createChatCompletionAsync(chatCompletionRequest);
        return FluentFuture.from(chatCompletionAsync).transform(chatCompletion -> {
            ChatMessage chatMessage = chatCompletion.getChoices().get(0).getMessage();
            if (chatMessage.getRole() == Role.USER) {
                return UserMessage.of(chatMessage.getContent());
            }
            if (chatMessage.getRole() == Role.SYSTEM) {
                return SystemMessage.of(chatMessage.getContent());
            }
            if (chatMessage.getRole() == Role.ASSISTANT) {
                return AssistantMessage.of(chatMessage.getContent());
            }
            throw new UnknownMessageException(String.format("Unknown role %s with message: %s ", new Object[]{chatMessage.getRole(), chatMessage.getContent()}));
        }, MoreExecutors.directExecutor());
    }
}

