/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.processor.module.openai.image;

import ai.knowly.langtorch.processor.llm.openai.service.OpenAIService;
import ai.knowly.langtorch.processor.llm.openai.service.schema.dto.image.CreateImageRequest;
import ai.knowly.langtorch.processor.llm.openai.service.schema.dto.image.ImageResult;
import ai.knowly.langtorch.processor.module.Processor;
import ai.knowly.langtorch.processor.module.openai.OpenAIServiceProvider;
import ai.knowly.langtorch.processor.module.openai.image.OpenAIImageProcessorConfig;
import ai.knowly.langtorch.processor.module.openai.image.OpenAIImageProcessorRequestConverter;
import ai.knowly.langtorch.schema.image.Image;
import ai.knowly.langtorch.schema.image.Images;
import ai.knowly.langtorch.schema.text.SingleText;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;

public class OpenAIImageProcessor
implements Processor<SingleText, Images> {
    private final OpenAIService openAIService;
    private OpenAIImageProcessorConfig openAIImageProcessorConfig = OpenAIImageProcessorConfig.builder().build();

    OpenAIImageProcessor(OpenAIService openAIService) {
        this.openAIService = openAIService;
    }

    private OpenAIImageProcessor() {
        this.openAIService = OpenAIServiceProvider.createOpenAIService();
    }

    public static OpenAIImageProcessor create(OpenAIService openAiApi) {
        return new OpenAIImageProcessor(openAiApi);
    }

    public static OpenAIImageProcessor create(String openAIKey) {
        return new OpenAIImageProcessor(OpenAIServiceProvider.createOpenAIService(openAIKey));
    }

    public static OpenAIImageProcessor create() {
        return new OpenAIImageProcessor();
    }

    public OpenAIImageProcessor withConfig(OpenAIImageProcessorConfig openAIImageProcessorConfig) {
        this.openAIImageProcessorConfig = openAIImageProcessorConfig;
        return this;
    }

    @Override
    public Images run(SingleText inputData) {
        CreateImageRequest createImageRequest = OpenAIImageProcessorRequestConverter.convert(this.openAIImageProcessorConfig, inputData.getText());
        ImageResult result = this.openAIService.createImage(createImageRequest);
        return Images.of(result.getCreated(), (List)result.getData().stream().map(image -> Image.of(image.getUrl())).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public ListenableFuture<Images> runAsync(SingleText inputData) {
        CreateImageRequest createImageRequest = OpenAIImageProcessorRequestConverter.convert(this.openAIImageProcessorConfig, inputData.getText());
        return FluentFuture.from(this.openAIService.createImageAsync(createImageRequest)).transform(result -> Images.of(result.getCreated(), (List)result.getData().stream().map(image -> Image.of(image.getUrl())).collect(ImmutableList.toImmutableList())), MoreExecutors.directExecutor());
    }
}

