/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.prompt.manager;

import ai.knowly.langtorch.prompt.template.PromptTemplate;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PromptTemplateTypeAdapter
extends TypeAdapter<PromptTemplate> {
    public void write(JsonWriter out, PromptTemplate promptTemplate) throws IOException {
        out.beginObject();
        out.name("template").value((String)promptTemplate.template().orElse(null));
        out.name("exampleHeader").value((String)promptTemplate.exampleHeader().orElse(null));
        out.name("examples").beginArray();
        for (String example : promptTemplate.examples()) {
            out.value(example);
        }
        out.endArray();
        out.name("variables").beginObject();
        for (Map.Entry entry : promptTemplate.variables().entrySet()) {
            out.name((String)entry.getKey()).value((String)entry.getValue());
        }
        out.endObject();
        out.endObject();
    }

    public PromptTemplate read(JsonReader in) throws IOException {
        PromptTemplate.Builder builder = PromptTemplate.builder();
        in.beginObject();
        block12: while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "template": {
                    builder.setTemplate(in.nextString());
                    continue block12;
                }
                case "exampleHeader": {
                    builder.setExampleHeader(in.nextString());
                    continue block12;
                }
                case "examples": {
                    in.beginArray();
                    ArrayList<String> examples = new ArrayList<String>();
                    while (in.hasNext()) {
                        examples.add(in.nextString());
                    }
                    in.endArray();
                    builder.setExamples(examples);
                    continue block12;
                }
                case "variables": {
                    in.beginObject();
                    HashMap<String, String> variables = new HashMap<String, String>();
                    while (in.hasNext()) {
                        String variableName = in.nextName();
                        String variableValue = in.nextString();
                        variables.put(variableName, variableValue);
                    }
                    in.endObject();
                    builder.addAllVariableValuePairs(variables);
                    continue block12;
                }
            }
            in.skipValue();
        }
        in.endObject();
        return builder.build();
    }
}

