/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.prompt.template;

import ai.knowly.langtorch.prompt.template.PromptTemplate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Optional;

final class AutoValue_PromptTemplate
extends PromptTemplate {
    private final Optional<String> template;
    private final Optional<String> exampleHeader;
    private final ImmutableList<String> examples;
    private final ImmutableMap<String, String> variables;

    private AutoValue_PromptTemplate(Optional<String> template, Optional<String> exampleHeader, ImmutableList<String> examples, ImmutableMap<String, String> variables) {
        this.template = template;
        this.exampleHeader = exampleHeader;
        this.examples = examples;
        this.variables = variables;
    }

    @Override
    public Optional<String> template() {
        return this.template;
    }

    @Override
    public Optional<String> exampleHeader() {
        return this.exampleHeader;
    }

    @Override
    public ImmutableList<String> examples() {
        return this.examples;
    }

    @Override
    public ImmutableMap<String, String> variables() {
        return this.variables;
    }

    public String toString() {
        return "PromptTemplate{template=" + this.template + ", exampleHeader=" + this.exampleHeader + ", examples=" + this.examples + ", variables=" + this.variables + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PromptTemplate) {
            PromptTemplate that = (PromptTemplate)o;
            return this.template.equals(that.template()) && this.exampleHeader.equals(that.exampleHeader()) && this.examples.equals(that.examples()) && this.variables.equals(that.variables());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.template.hashCode();
        h$ *= 1000003;
        h$ ^= this.exampleHeader.hashCode();
        h$ *= 1000003;
        h$ ^= this.examples.hashCode();
        h$ *= 1000003;
        return h$ ^= this.variables.hashCode();
    }

    @Override
    public PromptTemplate.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends PromptTemplate.Builder {
        private Optional<String> template = Optional.empty();
        private Optional<String> exampleHeader = Optional.empty();
        private ImmutableList<String> examples;
        private ImmutableMap.Builder<String, String> variablesBuilder$;
        private ImmutableMap<String, String> variables;

        Builder() {
        }

        private Builder(PromptTemplate source) {
            this.template = source.template();
            this.exampleHeader = source.exampleHeader();
            this.examples = source.examples();
            this.variables = source.variables();
        }

        @Override
        public PromptTemplate.Builder setTemplate(String template) {
            this.template = Optional.of(template);
            return this;
        }

        @Override
        public PromptTemplate.Builder setExampleHeader(String exampleHeader) {
            this.exampleHeader = Optional.of(exampleHeader);
            return this;
        }

        @Override
        public PromptTemplate.Builder setExamples(List<String> examples) {
            this.examples = ImmutableList.copyOf(examples);
            return this;
        }

        @Override
        ImmutableMap.Builder<String, String> variablesBuilder() {
            if (this.variablesBuilder$ == null) {
                if (this.variables == null) {
                    this.variablesBuilder$ = ImmutableMap.builder();
                } else {
                    this.variablesBuilder$ = ImmutableMap.builder();
                    this.variablesBuilder$.putAll(this.variables);
                    this.variables = null;
                }
            }
            return this.variablesBuilder$;
        }

        @Override
        public PromptTemplate build() {
            if (this.variablesBuilder$ != null) {
                this.variables = this.variablesBuilder$.buildOrThrow();
            } else if (this.variables == null) {
                this.variables = ImmutableMap.of();
            }
            if (this.examples == null) {
                String missing = " examples";
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PromptTemplate(this.template, this.exampleHeader, this.examples, this.variables);
        }
    }
}

