/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.store.vectordb.integration.pinecone;

import ai.knowly.langtorch.store.vectordb.integration.pinecone.PineconeAPI;
import ai.knowly.langtorch.store.vectordb.integration.pinecone.PineconeAuthenticationInterceptor;
import ai.knowly.langtorch.store.vectordb.integration.pinecone.schema.PineconeApiExecutionException;
import ai.knowly.langtorch.store.vectordb.integration.pinecone.schema.PineconeHttpParseException;
import ai.knowly.langtorch.store.vectordb.integration.pinecone.schema.PineconeInterruptedException;
import ai.knowly.langtorch.store.vectordb.integration.pinecone.schema.PineconeServiceConfig;
import ai.knowly.langtorch.store.vectordb.integration.pinecone.schema.dto.delete.DeleteRequest;
import ai.knowly.langtorch.store.vectordb.integration.pinecone.schema.dto.delete.DeleteResponse;
import ai.knowly.langtorch.store.vectordb.integration.pinecone.schema.dto.fetch.FetchRequest;
import ai.knowly.langtorch.store.vectordb.integration.pinecone.schema.dto.fetch.FetchResponse;
import ai.knowly.langtorch.store.vectordb.integration.pinecone.schema.dto.query.QueryRequest;
import ai.knowly.langtorch.store.vectordb.integration.pinecone.schema.dto.query.QueryResponse;
import ai.knowly.langtorch.store.vectordb.integration.pinecone.schema.dto.update.UpdateRequest;
import ai.knowly.langtorch.store.vectordb.integration.pinecone.schema.dto.update.UpdateResponse;
import ai.knowly.langtorch.store.vectordb.integration.pinecone.schema.dto.upsert.UpsertRequest;
import ai.knowly.langtorch.store.vectordb.integration.pinecone.schema.dto.upsert.UpsertResponse;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.google.common.flogger.FluentLogger;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.HttpException;
import retrofit2.Retrofit;
import retrofit2.adapter.guava.GuavaCallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class PineconeService {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final PineconeAPI api;

    public PineconeService(PineconeServiceConfig pineconeServiceConfig) {
        ObjectMapper mapper = PineconeService.defaultObjectMapper();
        OkHttpClient client = PineconeService.buildClient(pineconeServiceConfig);
        Retrofit retrofit = PineconeService.defaultRetrofit(pineconeServiceConfig.endpoint(), client, mapper);
        this.api = (PineconeAPI)retrofit.create(PineconeAPI.class);
    }

    public PineconeService(PineconeAPI api) {
        this.api = api;
    }

    public static <T> T execute(ListenableFuture<T> apiCall) {
        try {
            return (T)apiCall.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            ((FluentLogger.Api)((FluentLogger.Api)logger.atSevere()).withCause((Throwable)e)).log("Thread was interrupted during API call.");
            throw new PineconeInterruptedException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof HttpException) {
                HttpException httpException = (HttpException)e.getCause();
                try {
                    String errorBody = httpException.response().errorBody().string();
                    ((FluentLogger.Api)logger.atSevere()).log("HTTP Error: %s", (Object)errorBody);
                    throw new PineconeHttpParseException(errorBody);
                }
                catch (IOException ioException) {
                    ((FluentLogger.Api)((FluentLogger.Api)logger.atSevere()).withCause((Throwable)ioException)).log("Error while reading errorBody");
                }
            }
            throw new PineconeApiExecutionException(e);
        }
    }

    public static ObjectMapper defaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        return mapper;
    }

    public static OkHttpClient buildClient(PineconeServiceConfig pineconeServiceConfig) {
        ((FluentLogger.Api)logger.atInfo()).log("Pinecone:" + pineconeServiceConfig.apiKey());
        OkHttpClient.Builder builder = new OkHttpClient.Builder().addInterceptor((Interceptor)new PineconeAuthenticationInterceptor(pineconeServiceConfig.apiKey())).connectionPool(new ConnectionPool(5, 1L, TimeUnit.SECONDS)).readTimeout(pineconeServiceConfig.timeoutDuration().toMillis(), TimeUnit.MILLISECONDS);
        if (pineconeServiceConfig.enableLogging()) {
            HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
            builder.addInterceptor((Interceptor)logging.setLevel(HttpLoggingInterceptor.Level.BODY));
        }
        return builder.build();
    }

    public static Retrofit defaultRetrofit(String endpoint, OkHttpClient client, ObjectMapper mapper) {
        return new Retrofit.Builder().baseUrl(endpoint.startsWith("https://") ? endpoint : "https://" + endpoint).client(client).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).addCallAdapterFactory((CallAdapter.Factory)GuavaCallAdapterFactory.create()).build();
    }

    public UpsertResponse upsert(UpsertRequest request) {
        return PineconeService.execute(this.api.upsert(request));
    }

    public ListenableFuture<UpsertResponse> upsertAsync(UpsertRequest request) {
        return this.api.upsert(request);
    }

    public QueryResponse query(QueryRequest request) {
        return PineconeService.execute(this.api.query(request));
    }

    public ListenableFuture<QueryResponse> queryAsync(QueryRequest request) {
        return this.api.query(request);
    }

    public DeleteResponse delete(DeleteRequest request) {
        return PineconeService.execute(this.api.delete(request));
    }

    public ListenableFuture<DeleteResponse> queryAsync(DeleteRequest request) {
        return this.api.delete(request);
    }

    public FetchResponse fetch(FetchRequest request) {
        return PineconeService.execute(this.api.fetch(request.getNamespace(), request.getIds()));
    }

    public ListenableFuture<FetchResponse> fetchAsync(FetchRequest request) {
        return this.api.fetch(request.getNamespace(), request.getIds());
    }

    public UpdateResponse update(UpdateRequest request) {
        return PineconeService.execute(this.api.update(request));
    }

    public ListenableFuture<UpdateResponse> updateAsync(UpdateRequest request) {
        return this.api.update(request);
    }
}

