/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.utils;

import ai.knowly.langtorch.utils.ApiKey;
import com.google.common.flogger.FluentLogger;
import io.github.cdimascio.dotenv.Dotenv;
import java.util.Optional;

public class ApiKeyUtils {
    private ApiKeyUtils() {
    }

    public static void logPartialApiKey(FluentLogger logger, String provider, String apiKey) {
        ((FluentLogger.Api)logger.atInfo()).log("Using %s API key: ***************" + apiKey.substring(apiKey.length() - 6), (Object)provider);
    }

    public static String getOpenAIApiKeyFromEnv() {
        return ApiKeyUtils.getOpenAIApiKeyFromEnv(Optional.empty());
    }

    public static String getOpenAIApiKeyFromEnv(Optional<FluentLogger> logger) {
        String keyFromEnv = ApiKeyUtils.getKeyFromEnv(ApiKey.OPENAI_API_KEY);
        logger.ifPresent(l -> ApiKeyUtils.logPartialApiKey(l, ApiKey.OPENAI_API_KEY.name(), keyFromEnv));
        return keyFromEnv;
    }

    public static String getPineconeKeyFromEnv(Optional<FluentLogger> logger) {
        String keyFromEnv = ApiKeyUtils.getKeyFromEnv(ApiKey.PINECONE_API_KEY);
        logger.ifPresent(l -> ApiKeyUtils.logPartialApiKey(l, ApiKey.PINECONE_API_KEY.name(), keyFromEnv));
        return keyFromEnv;
    }

    public static String getPineconeKeyFromEnv() {
        return ApiKeyUtils.getPineconeKeyFromEnv(Optional.empty());
    }

    public static String getCohereAIApiKeyFromEnv() {
        return ApiKeyUtils.getCohereAIApiKeyFromEnv(Optional.empty());
    }

    public static String getCohereAIApiKeyFromEnv(Optional<FluentLogger> logger) {
        String keyFromEnv = ApiKeyUtils.getKeyFromEnv(ApiKey.COHERE_API_KEY);
        logger.ifPresent(l -> ApiKeyUtils.logPartialApiKey(l, ApiKey.COHERE_API_KEY.name(), keyFromEnv));
        return keyFromEnv;
    }

    private static String getKeyFromEnv(ApiKey apiKey) {
        Dotenv dotenv = Dotenv.configure().ignoreIfMissing().load();
        return dotenv.get(apiKey.name());
    }
}

