/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.capability.local.v1;

import ai.knowly.langtorch.capability.local.v1.CapabilityConfig;
import ai.knowly.langtorch.capability.local.v1.LocalCapabilityReadException;
import ai.knowly.langtorch.prompt.template.PromptTemplate;
import com.google.gson.Gson;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;

public class LocalCapabilityUnitReader {
    private static final String PROMPT_FILE_NAME = "prompt.txt";
    private static final String CONFIG_FILE_NAME = "config.json";
    private final String prompt;
    private final CapabilityConfig config;

    @Inject
    public LocalCapabilityUnitReader(String capabilityPath, Gson gson) {
        this.prompt = this.readFile(capabilityPath, TARGET.PROMPT);
        this.config = (CapabilityConfig)gson.fromJson(this.readFile(capabilityPath, TARGET.CONFIG), CapabilityConfig.class);
    }

    public String getPrompt() {
        return this.prompt;
    }

    public CapabilityConfig getConfig() {
        return this.config;
    }

    public PromptTemplate getPromptTemplate() {
        return PromptTemplate.builder().setTemplate(this.prompt).build();
    }

    private String readFile(String folderPath, TARGET target) {
        String string;
        String fileName = target == TARGET.CONFIG ? CONFIG_FILE_NAME : PROMPT_FILE_NAME;
        String path = String.format("%s/%s", folderPath, fileName);
        FileInputStream inputStream = new FileInputStream(path);
        try {
            string = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new LocalCapabilityReadException(e);
            }
        }
        inputStream.close();
        return string;
    }

    private static enum TARGET {
        CONFIG,
        PROMPT;

    }
}

