/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.capability.modality.text;

import ai.knowly.langtorch.capability.modality.text.Parsers;
import ai.knowly.langtorch.capability.modality.text.TextLLMCapabilityWithMemory;
import ai.knowly.langtorch.processor.Processor;
import ai.knowly.langtorch.schema.chat.ChatMessage;
import ai.knowly.langtorch.schema.text.MultiChatMessage;
import ai.knowly.langtorch.store.memory.Memory;
import ai.knowly.langtorch.store.memory.conversation.ConversationMemoryContext;
import com.google.common.flogger.FluentLogger;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import javax.inject.Inject;

public class ChatCompletionLLMCapability<I, O>
implements TextLLMCapabilityWithMemory<I, MultiChatMessage, ChatMessage, O, ChatMessage, ConversationMemoryContext> {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final Processor<MultiChatMessage, ChatMessage> processor;
    private final Parsers<I, MultiChatMessage, ChatMessage, O> parsers;
    private final Memory<ChatMessage, ConversationMemoryContext> memory;
    private boolean verbose;

    @Inject
    public ChatCompletionLLMCapability(Processor<MultiChatMessage, ChatMessage> processor, Parsers<I, MultiChatMessage, ChatMessage, O> parsers, Memory<ChatMessage, ConversationMemoryContext> memory) {
        this.processor = processor;
        this.parsers = parsers;
        this.memory = memory;
        this.verbose = false;
    }

    protected ChatCompletionLLMCapability<I, O> withVerboseMode(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    @Override
    public MultiChatMessage preProcess(I inputData) {
        if (inputData instanceof MultiChatMessage) {
            return (MultiChatMessage)inputData;
        }
        return this.parsers.getInputParser().map(parser -> (MultiChatMessage)parser.parse(inputData)).orElseThrow(() -> new IllegalArgumentException("Input data is not a MultiChatMessage and no input parser is present."));
    }

    @Override
    public O postProcess(ChatMessage outputData) {
        return (O)this.parsers.getOutputParser().map(parser -> parser.parse(outputData)).orElseThrow(() -> new IllegalArgumentException("Output data type is not ChatMessage and no output parser is present."));
    }

    @Override
    public Memory<ChatMessage, ConversationMemoryContext> getMemory() {
        return this.memory;
    }

    @Override
    public O run(I inputData) {
        return this.postProcess(this.generateMemorySideEffectResponse((MultiChatMessage)this.preProcess((Object)inputData)));
    }

    private ChatMessage generateMemorySideEffectResponse(MultiChatMessage multiChatMessage) {
        if (this.verbose) {
            ((FluentLogger.Api)logger.atInfo()).log("Memory before processing: %s", this.memory);
        }
        ChatMessage response = this.processor.run(this.getMessageWithMemorySideEffect(multiChatMessage));
        multiChatMessage.getMessages().forEach(this.memory::add);
        this.memory.add(response);
        return response;
    }

    private MultiChatMessage getMessageWithMemorySideEffect(MultiChatMessage message) {
        String memoryContext = this.memory.getMemoryContext().get();
        if (memoryContext.isEmpty()) {
            return message;
        }
        MultiChatMessage updatedMessage = message.getMessages().stream().map(chatMessage -> ChatMessage.of(String.format("%s%nBelow is my query:%n%s", memoryContext, chatMessage.toString()), chatMessage.getRole())).collect(MultiChatMessage.toMultiChatMessage());
        if (this.verbose) {
            ((FluentLogger.Api)logger.atInfo()).log("Updated Message with Memory Side Effect: %s", (Object)updatedMessage);
        }
        return updatedMessage;
    }

    @Override
    public ListenableFuture<O> runAsync(I inputData) {
        return FluentFuture.from((ListenableFuture)Futures.immediateFuture(inputData)).transform(this::run, MoreExecutors.directExecutor());
    }
}

