/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.connector.markdown;

import ai.knowly.langtorch.connector.Connector;
import ai.knowly.langtorch.connector.markdown.MarkdownConnectorOption;
import ai.knowly.langtorch.connector.markdown.MarkdownReadException;
import com.google.common.flogger.FluentLogger;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;
import javax.inject.Inject;
import lombok.NonNull;

public class MarkdownConnector
implements Connector<String> {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final MarkdownConnectorOption readOption;

    @Inject
    public MarkdownConnector(@NonNull MarkdownConnectorOption readOption) {
        if (readOption == null) {
            throw new NullPointerException("readOption is marked non-null but is null");
        }
        this.readOption = readOption;
    }

    @Override
    public Optional<String> read() {
        try {
            return Optional.of(new String(Files.readAllBytes(Paths.get(this.readOption.getFilePath(), new String[0])), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atSevere()).withCause((Throwable)e)).log("Error reading Markdown file.");
            throw new MarkdownReadException(e);
        }
    }
}

