/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.connector.pdf;

import ai.knowly.langtorch.connector.Connector;
import ai.knowly.langtorch.connector.pdf.PDFConnectorOption;
import com.google.common.flogger.FluentLogger;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;
import lombok.NonNull;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;

public class PDFConnector
implements Connector<String> {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final PDFConnectorOption readOption;

    @Inject
    public PDFConnector(@NonNull PDFConnectorOption readOption) {
        if (readOption == null) {
            throw new NullPointerException("readOption is marked non-null but is null");
        }
        this.readOption = readOption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<String> read() {
        Optional<String> optional;
        block6: {
            PDDocument document = PDDocument.load((File)new File(this.readOption.getFilePath()));
            try {
                PDFTextStripper pdfStripper = new PDFTextStripper();
                optional = Optional.of(pdfStripper.getText(document));
                if (Collections.singletonList(document).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (Collections.singletonList(document).get(0) != null) {
                        document.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    ((FluentLogger.Api)((FluentLogger.Api)logger.atSevere()).withCause((Throwable)e)).log("Error reading PDF file.");
                    return Optional.empty();
                }
            }
            document.close();
        }
        return optional;
    }
}

