/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.connector.spreadsheet;

import ai.knowly.langtorch.connector.ConnectorOption;
import java.util.Optional;
import lombok.NonNull;

public class SpreadSheetConnectorOption
implements ConnectorOption {
    @NonNull
    private String filePath;
    private String separatorForEachLine;
    private SpreadSheetFormat spreadSheetFormat;

    public Optional<String> getSeparatorForEachLine() {
        return Optional.ofNullable(this.separatorForEachLine);
    }

    public Optional<SpreadSheetFormat> getSpreadSheetFormat() {
        return Optional.ofNullable(this.spreadSheetFormat);
    }

    SpreadSheetConnectorOption(@NonNull String filePath, String separatorForEachLine, SpreadSheetFormat spreadSheetFormat) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        this.filePath = filePath;
        this.separatorForEachLine = separatorForEachLine;
        this.spreadSheetFormat = spreadSheetFormat;
    }

    public static SpreadSheetConnectorOptionBuilder builder() {
        return new SpreadSheetConnectorOptionBuilder();
    }

    public SpreadSheetConnectorOptionBuilder toBuilder() {
        return new SpreadSheetConnectorOptionBuilder().setFilePath(this.filePath).setSeparatorForEachLine(this.separatorForEachLine).setSpreadSheetFormat(this.spreadSheetFormat);
    }

    @NonNull
    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(@NonNull String filePath) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        this.filePath = filePath;
    }

    public void setSeparatorForEachLine(String separatorForEachLine) {
        this.separatorForEachLine = separatorForEachLine;
    }

    public void setSpreadSheetFormat(SpreadSheetFormat spreadSheetFormat) {
        this.spreadSheetFormat = spreadSheetFormat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpreadSheetConnectorOption)) {
            return false;
        }
        SpreadSheetConnectorOption other = (SpreadSheetConnectorOption)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$filePath = this.getFilePath();
        String other$filePath = other.getFilePath();
        if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
            return false;
        }
        Optional<String> this$separatorForEachLine = this.getSeparatorForEachLine();
        Optional<String> other$separatorForEachLine = other.getSeparatorForEachLine();
        if (this$separatorForEachLine == null ? other$separatorForEachLine != null : !((Object)this$separatorForEachLine).equals(other$separatorForEachLine)) {
            return false;
        }
        Optional<SpreadSheetFormat> this$spreadSheetFormat = this.getSpreadSheetFormat();
        Optional<SpreadSheetFormat> other$spreadSheetFormat = other.getSpreadSheetFormat();
        return !(this$spreadSheetFormat == null ? other$spreadSheetFormat != null : !((Object)this$spreadSheetFormat).equals(other$spreadSheetFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpreadSheetConnectorOption;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
        Optional<String> $separatorForEachLine = this.getSeparatorForEachLine();
        result = result * 59 + ($separatorForEachLine == null ? 43 : ((Object)$separatorForEachLine).hashCode());
        Optional<SpreadSheetFormat> $spreadSheetFormat = this.getSpreadSheetFormat();
        result = result * 59 + ($spreadSheetFormat == null ? 43 : ((Object)$spreadSheetFormat).hashCode());
        return result;
    }

    public String toString() {
        return "SpreadSheetConnectorOption(filePath=" + this.getFilePath() + ", separatorForEachLine=" + this.getSeparatorForEachLine() + ", spreadSheetFormat=" + this.getSpreadSheetFormat() + ")";
    }

    public static class SpreadSheetConnectorOptionBuilder {
        private String filePath;
        private String separatorForEachLine;
        private SpreadSheetFormat spreadSheetFormat;

        SpreadSheetConnectorOptionBuilder() {
        }

        public SpreadSheetConnectorOptionBuilder setFilePath(@NonNull String filePath) {
            if (filePath == null) {
                throw new NullPointerException("filePath is marked non-null but is null");
            }
            this.filePath = filePath;
            return this;
        }

        public SpreadSheetConnectorOptionBuilder setSeparatorForEachLine(String separatorForEachLine) {
            this.separatorForEachLine = separatorForEachLine;
            return this;
        }

        public SpreadSheetConnectorOptionBuilder setSpreadSheetFormat(SpreadSheetFormat spreadSheetFormat) {
            this.spreadSheetFormat = spreadSheetFormat;
            return this;
        }

        public SpreadSheetConnectorOption build() {
            return new SpreadSheetConnectorOption(this.filePath, this.separatorForEachLine, this.spreadSheetFormat);
        }

        public String toString() {
            return "SpreadSheetConnectorOption.SpreadSheetConnectorOptionBuilder(filePath=" + this.filePath + ", separatorForEachLine=" + this.separatorForEachLine + ", spreadSheetFormat=" + (Object)((Object)this.spreadSheetFormat) + ")";
        }
    }

    public static enum SpreadSheetFormat {
        CSV,
        EXCEL;

    }
}

