/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.connector.sql;

import ai.knowly.langtorch.connector.Connector;
import ai.knowly.langtorch.connector.sql.Records;
import ai.knowly.langtorch.connector.sql.ResultSetTransform;
import ai.knowly.langtorch.connector.sql.SQLConnectorOption;
import ai.knowly.langtorch.connector.sql.SQLExecutionException;
import com.google.common.flogger.FluentLogger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import javax.inject.Inject;
import lombok.NonNull;

public class MySQLConnector
implements Connector<Records> {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final SQLConnectorOption readOption;

    @Inject
    public MySQLConnector(@NonNull SQLConnectorOption readOption) {
        if (readOption == null) {
            throw new NullPointerException("readOption is marked non-null but is null");
        }
        this.readOption = readOption;
    }

    @Override
    public Optional<Records> read() {
        Optional<Records> optional;
        block9: {
            Optional<Connection> newConnection = this.openConnection(this.readOption);
            if (!newConnection.isPresent()) {
                ((FluentLogger.Api)logger.atSevere()).log("Fail to open connection to MySQL Database");
                return Optional.empty();
            }
            Statement stmt = newConnection.get().createStatement();
            try {
                ResultSet resultSet = stmt.executeQuery(this.readOption.getQuery());
                optional = Optional.ofNullable(ResultSetTransform.transform(resultSet));
                if (stmt == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    ((FluentLogger.Api)((FluentLogger.Api)logger.atSevere()).withCause((Throwable)e)).log("Error executing query in the MySQL Database");
                    return Optional.empty();
                }
            }
            stmt.close();
        }
        return optional;
    }

    private Optional<Connection> openConnection(SQLConnectorOption readOption) {
        if (readOption.getConnection().isPresent()) {
            return readOption.getConnection();
        }
        if (!this.isEligibleForConnection(readOption)) {
            try {
                return Optional.of(DriverManager.getConnection(readOption.getConnectionDetail().get().getUrl().get(), readOption.getConnectionDetail().get().getUser().get(), readOption.getConnectionDetail().get().getPassword().get()));
            }
            catch (SQLException e) {
                ((FluentLogger.Api)((FluentLogger.Api)logger.atSevere()).withCause((Throwable)e)).log("Fail to establish a new connection to database");
                throw new SQLExecutionException("Fail to establish a new connection to database", e);
            }
        }
        return Optional.empty();
    }

    private boolean isEligibleForConnection(SQLConnectorOption readOption) {
        return readOption.getConnectionDetail().isPresent() && readOption.getConnectionDetail().get().getUrl().isPresent() && readOption.getConnectionDetail().get().getUser().isPresent() && readOption.getConnectionDetail().get().getPassword().isPresent();
    }
}

